% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map2_plot}
\alias{map2_plot}
\alias{pmap_plot}
\title{Map over multiple inputs simultaneously and return a vector of plots}
\usage{
map2_plot(.x, .y, .f, ...)

pmap_plot(.l, .f, ...)
}
\arguments{
\item{.x, .y}{Vectors of the same length. A vector of length 1 will be recycled.}

\item{.f}{A function, formula, or atomic vector (see \code{\link[purrr]{map2}} for details)}

\item{...}{additional arguments passed on to .f.}

\item{.l}{A list of lists. The length of .l determines the number of arguments that .f will be called with. List names will be used if present.}
}
\description{
Map over multiple inputs simultaneously and return a vector of plots
}
\details{
See \code{\link[purrr]{map2}}
}
\examples{
\donttest{
library(tidyr)
library(purrr)
library(plotly)
library(dplyr)

iris \%>\%
  nest(data = -Species) \%>\%
  mutate(
    mod = map(data, ~ lm(Sepal.Length ~ Sepal.Width, data = .x)),
    panel = map2_plot(data, mod, function(data, mod) {
      plot_ly(data = data, x = ~Sepal.Width, y = ~Sepal.Length,
        type = "scatter", mode = "markers", name = "data") \%>\%
        add_trace(data = data, x = ~Sepal.Width, y = ~predict(mod),
          mode = "lines", name = "lm")
    })) \%>\%
  trelliscope(name = "iris")
}
}
