% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox.R
\name{efftox_process}
\alias{efftox_process}
\title{Process RStan samples from an EffTox model}
\usage{
efftox_process(dat, fit)
}
\arguments{
\item{dat}{An instance of \code{\link{efftox_params}}, a list of EffTox
parameters. An example is yielded by \code{\link{efftox_parameters_demo}}.}

\item{fit}{An instance of \code{rstan::stanmodel}, derived by sampling an
EffTox model. Use \code{stan::sampling(stanmodels$EffTox, data = dat)}.}
}
\value{
An instance of \code{\link{efftox_analysis}}.
}
\description{
Process RStan samples from an EffTox model to make inferences
about dose-acceptability, dose-utility and which dose should be recommended
next.
}
\examples{
dat <- efftox_parameters_demo()
dat$num_patients <- 3
dat$eff <- c(0, 1, 1)
dat$tox <- c(0, 0, 1)
dat$doses <- c(1, 2, 3)
fit <- rstan::sampling(stanmodels$EffTox, data = dat)
decision <- efftox_process(dat, fit)
decision$recommended_dose == 3
}
\seealso{
\code{\link{efftox_params}}

\code{\link{efftox_parameters_demo}}
}
