% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRM.R
\docType{class}
\name{crm_fit-class}
\alias{crm_fit-class}
\alias{crm_fit}
\title{Class of model fit by \pkg{trialr} using the CRM dose-finding design.}
\usage{
crm_fit(dose_indices, recommended_dose, prob_tox, median_prob_tox,
  modal_mtd_candidate, prob_mtd, dat, fit)
}
\arguments{
\item{dose_indices}{A vector of integers representing the dose-levels under
consideration.}

\item{recommended_dose}{An integer representing the dose-level recommended
for the next patient or cohort; or \code{NA} if stopping is recommended.
The recommended dose typically has associated probability of DLT closest to
the target toxicity rate. Contrast to \code{modal_mtd_candidate}.}

\item{prob_tox}{The posterior mean probabilities of toxicity at doses 1:n;
a vector of numbers between 0 and 1.}

\item{median_prob_tox}{The posterior median probabilities of toxicity at doses
1:n; a vector of numbers between 0 and 1.}

\item{modal_mtd_candidate}{An integer representing the dose-level most likely
to be the MTD, i.e. the dose-level that maximises \code{prob_mtd}.}

\item{prob_mtd}{The posterior probability that each dose is the MTD, by the
chosen model; a vector of numbers between 0 and 1.}

\item{dat}{Object \code{\link{crm_params}} containing data passed to
\code{\link[rstan:sampling]{sampling}}.}

\item{fit}{An object of class \code{\link[rstan:stanfit]{stanfit}},
containing the posterior samples.}
}
\description{
Class of model fit by \pkg{trialr} using the CRM dose-finding design.
}
\details{
See \code{methods(class = "crm_fit")} for an overview of available
methods.
}
\seealso{
\code{\link{stan_crm}}
\code{\link{crm_process}}
}
