% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield.R
\name{shield}
\alias{shield}
\title{Attributes protection}
\usage{
shield(obj, at, propagate = "some", keep_also = NULL)
}
\arguments{
\item{obj}{An object.}

\item{at}{A named list, the attributes to be possibly added to 
\code{obj}.}

\item{propagate}{character. The method to be applied, one of \code{"all"}, \code{"most"}, 
\code{"some"}, \code{"none"}, \code{"many"}. 

If \code{propagate="some"} (the default), 
the attributes of \code{obj} are kept unchanged 
(up to the value of \code{keep_also}). 

If \code{propagate="all"} (not advised), 
the attributes of the returned object 
are exactly \code{at} (up to the value of \code{keep_also}). 

If \code{propagate="none"} (not advised either), 
the attributes of the returned object 
are \code{NULL} (up to the value of \code{keep_also}). 

If \code{propagate="most"}, new attributes taken from \code{at} 
will be added to \code{obj}; however, attributes found in \code{at} 
that have the same name as attributes of \code{obj} are not 
considered.}

\item{keep_also}{character. A vector of named attributes to be added to 
the final result.}
}
\value{
The object \code{obj} with possibly different attributes.
}
\description{
The function \code{shield} is made to facilitate 
the propagation  of attributes of an object \code{obj} 
through R operations.
}
\examples{
library(dplyr)
df <- data.frame(x = sample(10, 5, rep = TRUE),
                 y = sample(10, 5, rep = TRUE)) \%>\%
  at_mutate(example="yes",
            package="dplyr", 
            class = c("my_tbl", "data.frame"))
tribe(df)

# Attributes are lost when the object passes through dplyr verbs
df2 <- df \%>\% 
  mutate(z = 3)
tribe(df2)

# Most attributes are kept
df3 <- shield(df2, tribe(df), propagate = "most")
tribe(df3)

# To keep the class, use 'keep_also'
df4 <- shield(df2, tribe(df), propagate = "most", keep_also = "class")
tribe(df4)

}
