% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim an R Object}
\usage{
trim(obj, obj_arg_name = NULL, fun = predict, size_target = 0,
  tolerate_warnings = FALSE, verbose = TRUE, dont_touch = list(),
  ...)
}
\arguments{
\item{obj}{\code{list} R object to be trimmed. _MUST_ inherit from the
'list' class.}

\item{obj_arg_name}{\code{character} what is the name of the parameter, that
'obj' must be set to, when invoking 'fun'. Defaults to NULL, in which case
the function assumes, that the 'obj' matches the first parameter of 'fun'.}

\item{fun}{\code{function} function that must return the same results, when
invoked with 'obj' both before and after trimming.}

\item{size_target}{\code{numeric} desired maximum size in _MegaBytes_ of 
object after trimming has been conducted. When this size is achieved, 
the trimming stops. Defaults to 0, in which case trimming continues, until
no further trimming can be done without breaking results from 'fun'.}

\item{tolerate_warnings}{\code{logical} tolerate warnings (=TRUE) Or
not (=FALSE) from function call results?}

\item{verbose}{\code{logical} print messages?}

\item{dont_touch}{\code{list} list with name indices of elements, that must 
not be removed from object by trimming procedure.}

\item{...}{other (named) arguments for 'fun'.}
}
\description{
Trims an R object whilst presuming the results of a given function call,
where the R object is given as an argument. One popular example could be 
trimming an R model object whilst presuming the results of the 
\code{\link{predict}} function on a sample of data.
}
\examples{
# get training data for predictive model.
trn <- datasets::mtcars

# estimate model.
mdl <- lm(mpg ~ ., data = trn)
trim(obj = mdl, obj_arg_name = "object", fun = predict, newdata = trn)
trim(obj = mdl, obj_arg_name = "object", fun = predict, newdata = trn,
dont_touch = list(c("model"), c("qr","tol")))
}
