\name{print.colGxE}
\alias{print.colGxE}
\alias{getGxEstats}
\title{
Printing and Storing of colGxE objects
}
\description{
\code{Print}s the statistics computed with \code{\link{colGxE}}. \code{getGxEstats} generates a data frame
containing these statistics.
}
\usage{
\method{print}{colGxE}(x, top = 5, digits = 4, onlyGxE = FALSE, ...)

getGxEstats(x, top = NA, sortBy = c("none", "gxe", "lrt2df", "wald2df", "lrt1df", "g"))
}

\arguments{
  \item{x}{an object of class \code{colGxE}, i.e. the output of the function \code{\link{colGxE}}.
}
  \item{top}{number of top interactions that should be printed or stored in a data frame. If \code{top} is set to \code{NA}, \code{0}, 
    or to a value that is negative of larger than the number of interactions, then the statistics for all interactions are printed or stored
    in the same order as they were in the genotype matrix \code{mat.snp} used in \code{\link{colGxE}}. Otherwise, 
    the \code{top} interactions with the smallest p-values are printed or stored, where \code{print} uses the p-values of the GxE effect
    to order the interactions, while in \code{generateGxEstats} the p-values of test specified by \code{sortBy} are employed. Ignored
    if \code{sortBy = "none"}.
}
  \item{onlyGxE}{logical indicating whether only the statistics for the parameter of the GxE interaction should be printed.
    If \code{FALSE}, the statistics for both parameters in the model as well as the odds ratios for the exposed trios and statistics for
    the 2 df likelihood ratio test and the 2 df Wald test (if these odds ratios and statistics were computed by \code{\link{colGxE}})
    are shown.
}
  \item{digits}{number of digits that should be printed.}
  \item{...}{ignored.}
  \item{sortBy}{character string specifying by the p-value of which test the SNPs should be sorted. If \code{"none"} (default), the
    SNPs are not sorted and the SNPs are in the same order as in the genotype matrix used to specify \code{mat.snp} in \code{\link{colGxE}}.}
}

\references{
Schwender, H., Taub, M.A., Beaty, T.H., Marazita, M.L., and Ruczinski, I. (2011). 
Rapid Testing of SNPs and Gene-Environment Interactions in Case-Parent Trio Data Based on 
Exact Analytic Parameter Estimation. \emph{Biometrics}. DOI: 10.1111/j.1541-0420.2011.01713.x.
}

\author{
Holger Schwender, \email{holger.schwender@udo.edu}
}

\seealso{
\code{\link{colGxE}}
}
\keyword{print}
\keyword{utilities}
