% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.test.R
\name{spectrum.test}
\alias{spectrum.test}
\title{Permutation-spectrum test for time-series data}
\usage{
spectrum.test(x = NULL, sims = 10^6, progress = TRUE)
}
\arguments{
\item{x}{A vector of time-series values (must have at least two data points)}

\item{sims}{Positive integer for the number of simulations to perform in the test}

\item{progress}{Logical; if \code{TRUE} the function uses a progress bar to track its simulations}
}
\description{
Computes the permutation-spectrum test to detect a periodic signal in a real or complex time-series vector.  The null hypothesis for
the test is that the values in the time-series vector are independent and identically distributed with no signal, and the alternative
hypothesis is that the time-series has at least one remaining periodic signal.  The test statistic is the maximum scaled intensity
of the observed time-series vector.  The p-value for the test is the probability of observing a maximum scaled intensity at least as
large as the observed value under the null distribution of exchangeability.  The null distribution for the test is simulated by applying
random permutations to the observed time-series.  The number of simulations is controlled by the \code{sims} parameter.
}
\examples{

data(garma)

#Show the intensity of a time-series vector
spectrum.test(SERIES1, sims = 100)
}
