\name{TVECM.sim}
\alias{TVECM.sim}
\title{Simulation and bootstrap of bivariate VECM/TVECM}
\description{
Estimate or bootstraps a multivariate Threshold VAR
}
\usage{
TVECM.sim(data,B,TVECMobject, nthresh=1, Thresh, beta, n=200, lag=1, type=c("simul","boot", "check"),  include = c("const", "trend","none", "both"), starting=NULL, innov=rmnorm(n, mean=0, varcov=varcov), varcov=diag(1,k), show.parMat=FALSE)
}


\value{
A matrix with the simulated/bootstraped series.
}
\arguments{
\item{data}{matrix of parameter to simulate}
\item{B}{Matrix of coefficients to simulate}
\item{TVECMobject}{Object computed by function TVECM() or linear VECM}
\item{nthresh}{number of threshold (see details)}
\item{Thresh}{The threshold value(s). Vector of length nthresh}
\item{beta}{The cointegrating value}
\item{n}{Number of observations to create when type="simul"}
\item{lag}{Number of lags to include in each regime}
\item{type}{Whether a bootstrap or simulation is to employ. See details}
\item{include}{Type of deterministic regressors to include. NOT WORKING PROPERLY CURRENTLY if not const}
\item{starting}{Starting values when a simulation with given parameter matrix is made}
\item{innov}{Innovations used for simulation. Should be matrix of dim nxk. By default multivariate normal.}
\item{varcov}{Variance-covariance matrix for the inov when default multivariate normal is used.}
\item{show.parMat}{Logical. Should the parameter matrix be shown? Usefull to understand how to give right input}
}
\details{
This function offers the possibility to generate series following a
VECM/TVECM from two approaches: bootstrap or simulation.

When the parameter matrix is given, on can only simulate a VECM
(nthresh=0) or TVECM (nthresh=1 or 2). One can have a specification with
constant (default), trend, both or none (see arg include). Order in
parameters is ECT/include/lags for VECM and
ECT1/include1/lags1/ECT2/include2/lags2 for TVECM.

The argument beta is the contegrating value on the right side of the
long-run relationship, and hence the function use the vector
(1,-beta). The innovations can be given by the user (a matrix of dim
nxk,here n does not include the starting values!), by default it uses a multivariate normal distribution, with covariance matrix specified by varcov.

The starting values (of dim lags x k) can be given. The user should take
care for their choice, since it is not sure that the simulated values will cross
the threshold even once. Notice that only one cointegrating value is allowed. User interested in simulating a VECM with more cointegrating values should do use the VAR representation and use TVAR.sim.

The second possibility is to bootstrap series. This is done on a object
generated by TVECM (or VECM). A simple residual bootstrap is done, or
one can simulate a serie with the same parameter matrix and with normal
distributed residuals (with variance pre-specified), corresponding to
Monte-carlo simulations.

One can alternatively give only the series, and then the function will call internally TVECM()
}
\seealso{
\code{\link{TVECM}} to estimate a TVECM,  \code{\link{VAR.sim}} to simulate/bootstrap a VAR. 
}
\author{Matthieu Stigler}
\examples{

###reproduce example in Enders 2004, p. 350
#see that:
a<-matrix(c(-0.2, 0.2), ncol=1)
b<-matrix(c(1,-1), nrow=1)
a%*%b

innov<-rmnorm(100, varcov=diag(2))
vecm1<-TVECM.sim(B=rbind(c(-0.2, 0,0), c(0.2, 0,0)), nthresh=0, beta=1,n=100, lag=1,include="none", innov=innov)
ECT<-vecm1[,1]-vecm1[,2]

#add an intercept as in panel B
b<-TVECM.sim(B=rbind(c(-0.2, 0.1,0,0), c(0.2,0.4, 0,0)), nthresh=0, n=100,beta=1, lag=1,include="const", innov=innov)



##Bootstrap a TVAR with 1 threshold (two regimes)
data(zeroyld)
dat<-zeroyld
TVECMobject<-TVECM(dat, nthresh=1, lag=1, ngridBeta=20, ngridTh=20, plot=FALSE)
TVECM.sim(TVECMobject=TVECMobject,type="boot")

##Check the bootstrap
all(TVECM.sim(TVECMobject=TVECM(dat, nthresh=1, lag=2, ngridBeta=20, ngridTh=20, plot=FALSE, include="none"),type="check")==dat)
}
\keyword{ ts }
\references{
TODO
}

