\name{VARrep}
\alias{VARrep}
\alias{VARrep.VAR}
\alias{VARrep.VECM}
\title{VAR representation}
\usage{
  VARrep(object, ...)

  \method{VARrep}{VECM} (object, ...)

  \method{VARrep}{VAR} (object, ...)
}
\arguments{
  \item{object}{An object of class \sQuote{VECM} created by
  \code{\link{VECM}}, or of class \sQuote{VAR} created by
  \code{\link{lineVar}}}

  \item{\dots}{Currently not used}
}
\value{
  A matrix containing the parameters of the VECM under
  their VAR representation.
}
\description{
  Show the VAR representation of a VECM
}
\examples{
data(barry)

# VECM model:
mod_vecm <- VECM(barry, lag=2, estim="ML")
VARrep(mod_vecm)

# VAR model:
mod_var <- lineVar(barry, lag=2, I="diff")
VARrep(mod_var)
}
\author{
  Matthieu Stigler
}
\references{
  Hamilton (1994) \emph{Time Series Analysis}, Princeton
  University Press
}
\keyword{cointegration}
\keyword{ts}
\keyword{VAR}
\keyword{VECM}

