# tsbox 0.2.0 (2019-08-06)

## Features

- Construction of expressions for data.tables are done problerly and now
  are able to contain spaces or non-ASCII characters
  (#151, thanks @stefanfritsch)
- ts_default() puts data frames in default order (ids, time, value) (#166)
- Consistent handling of non-default colnames and colorder in data frames (#166)
- Support for 'tis' time series (#150)
- Support for 'irts' time series, from package tseries
- Tweakes color schemes

## Bug fixes

- High-frequency conversion works with daylight saving time (#152)
- Do not run x13binary in tests on Solaris (#143)
- Use `key = id` when creating a tsibble (#156)
- ts_trend passes arguments to loess (#147)
- ts_summary works with single or irregular observations (#145, #146)
- ts_frequency handles na.rm correctly (#148)
- handles data sets from tsibbledata (#164)
- ts_lag handles negative `by` argument correctly (#177)


# tsbox 0.1.0 (2019-04-03)

## Changes

- Rectangular structures (`data.frame`, `tibble`, `data.table`) keep explicit
  NAs by default. Use `ts_na_omit()` to make explicit NAs implicit. As
  previously, `ts_regular()` makes implicit NAs explicit.


## New Functions and Features

- `ts_default`, new function to change column names to defaults (time, value), so
  that no auto detection is performed afterwards (#118)
- `ts_summary`, returns a data frame with summary information of a ts-boxable
  object. Also used to extract time series properties (`ts_summary(x)$start`,
  `ts_summary(x)$freq`, etc.)
- `ts_regular` gains `fill` argument, to specify replacement value for `NA` (#101)
- `ts_pc`, `ts_pcy`, `ts_diff`, `ts_diffy` have been rewritten and are much
  faster. They now return a series of the same length as the input, with `NA`s
  at the beginning.
- `ts_pca`, new function to calculate annualized percentage change rate
- `ts_span` gains `extend` argument, to add explicit `NA`s


## Bug fixes

- `ts_apply` pass on arguments. This allows functions generated by ts_ to pass
  on additional arguments. E.g., `ts_seas(AirPassengers, x11 = "")` (#115, #103)
- unnamed `tslist` objects of length 1 don't get an id anymore (#116)
- `ts_span` various fixes, boundary specification by shift string (`"1 year"`)
  or period now works as expected, also for non-heuristic series, such as
  `EuStockMarkets` (#106)
- time column of daily data is treated as Date and survives two way conversion
  (#114, #137)
- `ts_pick`, error if picked series is not in data (#100)
- error when data contains duplicated series (#102)
- `ts_plot`, improved axis labels for high frequency series (#117)
- fixed tsibble to anything conversion


## Deprecated

- `ts_start`, `ts_end`, use `ts_summary(x)$start` and `ts_summary(x)$end`
  instead.


# tsbox 0.0.3 (2018-06-18)

## Features

- Support for `tibbletime` time series (#90)

## Bug fixes

- Automatically detect numbers or text from 1600 to 2200 as time column (#92)
- Fix to correctly ensure uniqueness of non unique id combinations (#93)
- Fix to correctly parse `POSIXct` columns for monthly data in different time
  zones. Remove two way testing for daily series with `POSIXct` columns. This
  should fix mac binary build on CRAN (#97)

# tsbox 0.0.2 (2018-05-12)

## Features

- initial version


