/*
   MUTINFO - compute the mutual information from time delayed time series
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <sgtty.h>
#ifdef aix
#include <unistd.h>
#endif
#define FNAMSIZ 55  /* define this to be your maximum file name size */

main(argc, argv)


    int argc;
    char **argv;

{
 struct  sgttyb otty;
 FILE    *source;
 extern  char *optarg;
 extern  int  optind;
#ifdef aix
 int     option;
#else
 char    option;
#endif
 int     i, j, have_pipe, npt, ntau, maxbit, ixmax, trace;
 int     *intx, *inty, *s, *q, *q_unsort, *indices_x, *indices_y, *position;
 double  tau_min, tau_max, delta_tau, confidence;
 double  *x, *x0, freq;
 char    sfile[FNAMSIZ], name[BUFSIZ];
 char    usage[BUFSIZ], line[BUFSIZ];
 strcpy  (usage, "usage: mutinfo [-l tau(min)] [-u tau(max)] [-d delta(tau)]\n               [-m max.bit] [-c confidence level] [-trace]  filename");

 for (i=1; i < FNAMSIZ; i++) { sfile[i] = 0; }
 for (i=1; i < BUFSIZ;  i++) { name[i] = 0; }
 
 /* set the defaults */
 tau_min    = -1.0;
 tau_max    = -1.0;
 delta_tau  = 0.0;
 ntau       = 1000;
 maxbit     = 20;        /* default precision we handle is 20 bit */
 confidence = 0.2;       /* default confidence level */
 trace      = 0;

 /* scan for arguments :*/
 for (i=1; i < argc; i++)
    {
     if (strcmp("-trace", argv[i]) == 0)
         strcpy(argv[i], "-T");
    }

 while ((option=getopt(argc, argv, "Tl:u:d:m:c:")) != -1)
   {
    switch (option) 
     {
      case 'T':
            trace=1;
            break;
      case 'l':
            tau_min = atof(optarg);
            break;
      case 'u':
            tau_max = atof(optarg);
            break;
      case 'd':
            delta_tau = atof(optarg);
            break;
      case 'm':
            maxbit = atoi(optarg);
            break;
      case 'c':
            confidence = atof(optarg);
            break;
      case '?':
            fprintf (stderr, "%s\n", usage);
            exit (2);
     }
   }

 /* check if we obtain our input from a pipe: */
 have_pipe = gtty(fileno(stdin), &otty);
 /* returns 0 if we have a pipe open, otherwise -1 */

 if (optind >= argc)
    {
     if (!have_pipe)
       {
        fprintf (stderr, "%s\n", usage);
        exit (2);
       }
     else
       source = stdin;
    }
 else
    {
     strcpy (sfile, argv[optind]);
     if ((source = fopen(sfile, "r")) == NULL)  /* check if file exists */
        {
         perror (sfile);   /* complain about non-existing file */
         exit (1);
        }
    }

/* check if all necessary parameters have been specified */    
 if (tau_min == -1.0)    {fprintf (stderr, "minimum delay time: "); scanf("%lf", &tau_min);}
 if (tau_max == -1.0)    {fprintf (stderr, "maximum delay time: "); scanf("%lf", &tau_max);}

 /* now read the input: */
 fgets(line, sizeof(line), source);
 sscanf (line, "%s", &name[0]);
 fgets(line, sizeof(line), source);
 sscanf (line, "%d", &npt);
 fgets(line, sizeof(line), source);
 sscanf (line, "%lf", &freq);
 if (delta_tau == 0.0)
   {
 
   /* try to set the interval automatically : */
    delta_tau = (tau_max - tau_min)/ntau;
    if (delta_tau < 1./freq) 
       delta_tau = 1./freq;
   }
 
 /* reserve the necessary memory: */
 x0 = x = (double *) calloc (npt, sizeof(double));

 if (x0 == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce number of data.\n"); 
     exit (2);
    }

 i = 0;
 while ((fgets(line, sizeof(line), source) != NULL) && (i <= npt))
   {
    sscanf(line, "%lf", x++);
    i++;
   }
 
 if (!have_pipe) fclose(source);

 if (npt > i)
    {
     fprintf (stderr, "WARNING:  only %d data points found\n", i);
     npt = i;
    }

 /* reserve the necessary memory: */
 intx = (int *) calloc (npt, sizeof(int));
 inty = (int *) calloc (npt, sizeof(int));
 s = (int *) calloc (npt, sizeof(int));
 q = (int *) calloc (npt, sizeof(int));
 q_unsort = (int *) calloc (npt, sizeof(int));
 indices_x = (int *) calloc (npt, sizeof(int));
 indices_y = (int *) calloc (npt, sizeof(int));
 ixmax = (int) pow(2.0, (double) maxbit);
 position = (int *) calloc (ixmax+1, sizeof(int));

 if (intx == NULL || inty == NULL || s == NULL || q == NULL || q_unsort == NULL || indices_x == NULL || indices_y == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce number of data.\n"); 
     exit (2);
    }
 if (position == NULL)
    {
     fprintf (stderr, "ERROR:  Not enough memory; reduce maximum resolution.\n"); 
     exit (2);
    }

#if defined(hpux) | defined(aix)
 mutinfo (&tau_min, &tau_max, &delta_tau, &name[0], &npt, &freq, x0, intx, inty, s, q, q_unsort, indices_x, indices_y, position, &maxbit, &confidence, &trace);
#else
 mutinfo_(&tau_min, &tau_max, &delta_tau, &name[0], &npt, &freq, x0, intx, inty, s, q, q_unsort, indices_x, indices_y, position, &maxbit, &confidence, &trace);
#endif
}
