% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{summarise.tbl_ts}
\alias{summarise.tbl_ts}
\alias{summarize.tbl_ts}
\title{Collapse multiple rows to a single value}
\usage{
\method{summarise}{tbl_ts}(.data, ..., .drop = FALSE)

\method{summarize}{tbl_ts}(.data, ..., .drop = FALSE)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{Name-value pairs of expressions.}

\item{.drop}{\code{FALSE} returns a tsibble object as the input. \code{TRUE} drops a
tsibble and returns a tibble.}
}
\description{
Collapse multiple rows to a single value
}
\details{
Time index will not be collapsed by \code{summarise.tbl_ts}.
}
\examples{
# Sum over sensors ----
pedestrian \%>\%
  summarise(Total = sum(Count))
# Sum over sensors by days ----
pedestrian \%>\%
  index_by(Date) \%>\% 
  summarise(Total = sum(Count))
## .drop = TRUE ----
pedestrian \%>\%
  summarise(Total = sum(Count), .drop = TRUE)
}
\seealso{
\link[dplyr:summarise]{dplyr::summarise}

\link[dplyr:summarize]{dplyr::summarize}
}
