% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretcher}
\alias{stretcher}
\alias{pstretcher}
\title{Splits the input to a list according to the stretching window size.}
\usage{
stretcher(.x, .size = 1, .init = 1)

pstretcher(..., .size = 1, .init = 1)
}
\arguments{
\item{.x}{An object to slide over.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.init}{A positive integer for an initial window size.}

\item{...}{Multiple objects to be splitted in parallel.}

\item{x}{An objects to be splitted.}
}
\description{
Splits the input to a list according to the stretching window size.
}
\examples{
.x <- 1:5
.y <- 6:10
.z <- 11:15
.lst <- list(x = .x, y = .y, z = .z)
.df <- as.data.frame(.lst)

stretcher(.x, .size = 2)
stretcher(.lst, .size = 2)
pstretcher(.lst, .size = 2)
stretcher(.df, .size = 2)
pstretcher(.df, .df, .size = 2)
}
