% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-na.R
\name{fill_na}
\alias{fill_na}
\alias{fill_na.tbl_ts}
\title{Turn implicit missing values into explicit missing values}
\usage{
fill_na(.data, ...)

\method{fill_na}{tbl_ts}(.data, ..., .full = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{A set of name-value pairs. The values will replace existing explicit
missing values by variable, otherwise \code{NA}. The replacement values must be of
the same type as the original one.}

\item{.full}{\code{FALSE} to insert \code{NA} for each key within its own period. \code{TRUE}
to fill \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).}
}
\description{
Turn implicit missing values into explicit missing values
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = id(fruit), index = year
)

# leave NA as is ----
fill_na(harvest, .full = TRUE)
full_harvest <- fill_na(harvest, .full = FALSE)
full_harvest

# use fill() to fill `NA` by previous/next entry
full_harvest \%>\% 
  group_by(fruit) \%>\% 
  tidyr::fill(kilo, .direction = "down")

# replace NA with a specific value ----
harvest \%>\%
  fill_na(kilo = 0L)

# replace NA using a function by variable ----
harvest \%>\%
  fill_na(kilo = sum(kilo))

# replace NA using a function for each group ----
harvest \%>\%
  group_by(fruit) \%>\%
  fill_na(kilo = sum(kilo))

# replace NA ----
pedestrian \%>\%
  group_by(Sensor) \%>\%
  fill_na(Count = as.integer(median(Count)))
}
\seealso{
\link{count_gaps}, \link{case_na}, \link[tidyr:fill]{tidyr::fill}, \link[tidyr:replace_na]{tidyr::replace_na}
}
