% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble-pkg.R
\docType{package}
\name{tsibble-package}
\alias{tsibble-package}
\title{tsibble: tidy temporal data frames and tools}
\description{
\if{html}{\figure{logo.png}{options: align='right'}}
The \strong{tsibble} package provides a data class of \code{tbl_ts} to represent tidy
temporal-context data. A tsibble consists of a time index, key, and other
measured variables in a data-centric format, which is built on top of the tibble.
}
\section{Index}{

The time indices are preserved as the essential data component of the tsibble,
instead of implicit attribute (for example, the \code{tsp} attribute in a \code{ts} object). A
few index classes, such as \code{Date}, \code{POSIXct}, and \code{difftime}, forms the basis of
the tsibble, with new additions \link{yearweek}, \link{yearmonth}, and \link{yearquarter}
representing year-week, year-month, and year-quarter respectively. Any arbitrary
index class are also supported, including \code{zoo::yearmth}, \code{zoo::yearqtr}, and
\code{nanotime}.
For a \code{tbl_ts} of regular interval,
a choice of index representation has to be made. For example, a monthly data
should correspond to time index created by \link{yearmonth} or \code{zoo::yearmth},
instead of \code{Date} or \code{POSIXct}. Because months in a year ensures the regularity,
12 months every year. However, if using \code{Date}, a month contains days ranging
from 28 to 31 days, which results in irregular time space. This is also applicable
to year-week and year-quarter.

Since the \strong{tibble} that underlies the \strong{tsibble} only accepts a 1d atomic
vector or a list, a \code{tbl_ts} doesn't accept \code{POSIXlt} and \code{timeDate} columns.
}

\section{Key}{

Key variable(s) together with the index uniquely identifies each record. And
the key also imposes the structure on a tsibble, which can be created via the
\link{id} function as identifiers:
\itemize{
\item None: an implicit variable \code{id()} resulting a univariate time series.
\item A single variable: an explicit variable. For example, \code{data(pedestrian)}
uses the \code{id(Sensor)} column as the key.
\item Nested variables: a nesting of one variable under another. For example,
\code{data(tourism)} contains two geographical locations: \code{Region} and \code{State}.
\code{Region} is the lower level than \code{State} in Australia; in other words, \code{Region}
is nested into \code{State}, which naturally forms a hierarchy. A vertical bar (\code{|})
is used to describe this nesting relationship, and thus \code{Region} | \code{State}.
In theory, nesting can involve infinite levels, so is \code{tsibble}.
\item Crossed variables: a crossing of one variable with another. For example,
the geographical locations are crossed with the purpose of visiting (\code{Purpose})
in the \code{data(tourism)}. A comma (\code{,}) is used to indicate this crossing
relationship. Nested and crossed variables can be combined, such as
\code{data(tourism)} using \code{id(Region | State, Purpose)}.
}

These key variables describe the data structure, which will prove useful in
data visualisation and statistical modelling.
}

\section{Interval}{

The \link{interval} function returns the interval associated with the tsibble.
\itemize{
\item Regular: the value and its time unit including "nanosecond", "microsecond",
"millisecond", "second", "minute", "hour", "day", "week", "month", "quarter",
"year". An unrecognisable time interval is labelled as "unit".
\item Irregular: \code{as_tsibble(regular = FALSE)} gives the irregular tsibble. It is
marked with \code{!}.
\item Unknown: if there is only one entry for each key variable, the interval
cannot be determined (\code{?}).
}

An interval is obtained based on the corresponding index representation:
\itemize{
\item integer/numeric: either "unit" or "year"
\item \code{yearquarter}/\code{yearqtr}: "quarter"
\item \code{yearmonth}/\code{yearmth}: "month"
\item \code{yearweek}: "week"
\item \code{Date}: "day"
\item \code{POSIXct}: "hour", "minute", "second", "millisecond", "microsecond"
\item \code{nanotime}: "nanosecond"
}
}

\section{Print options}{

The tsibble package fully utilises the \code{print} method from the tibble. Please
refer to \link[tibble:tibble-package]{tibble::tibble-package} to change display options.
}

\examples{
# create a tsibble w/o a key ----
tsbl1 <- tsibble(
  date = seq(as.Date("2017-01-01"), as.Date("2017-01-10"), by = 1),
  value = rnorm(10),
  key = id(), index = date
)
tsbl1

# create a tsibble with one key ----
tsbl2 <- tsibble(
  qtr = rep(yearquarter(seq(2010, 2012.25, by = 1 / 4)), 3),
  group = rep(c("x", "y", "z"), each = 10),
  value = rnorm(30),
  key = id(group), index = qtr
)
tsbl2
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pkg.earo.me/tsibble}
  \item Report bugs at \url{https://github.com/tidyverts/tsibble/issues}
}

}
\author{
\strong{Maintainer}: Earo Wang \email{earo.wang@gmail.com} (0000-0001-6448-5260)

Authors:
\itemize{
  \item Di Cook (0000-0002-3813-7155) [thesis advisor]
  \item Rob Hyndman (0000-0002-2140-5352) [thesis advisor]
}

Other contributors:
\itemize{
  \item Mitchell O'Hara-Wild [contributor]
}

}
