% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{tsibble}
\alias{tsibble}
\title{Create a tsibble object}
\usage{
tsibble(..., key = id(), index, regular = TRUE)
}
\arguments{
\item{...}{A set of name-value pairs. The names of "key" and "index" should
be avoided as they are used as the arguments.}

\item{key}{Structural variable(s) that define unique time indices, used with
the helper \link{id}. If a univariate time series (without an explicit key),
simply call \code{id()}. See below for details.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The
interval is determined by the greatest common divisor of positive time distances,
if \code{TRUE}.}
}
\value{
A tsibble object.
}
\description{
Create a tsibble object
}
\details{
A tsibble is sorted by its key first and index.
}
\section{Index}{

The time indices are preserved as the essential data component of the tsibble,
instead of implicit attribute (for example, the \code{tsp} attribute in a \code{ts} object). A
few index classes, such as \code{Date}, \code{POSIXct}, and \code{difftime}, forms the basis of
the tsibble, with new additions \link{yearweek}, \link{yearmonth}, and \link{yearquarter}
representing year-week, year-month, and year-quarter respectively. Any arbitrary
index class are also supported, including \code{zoo::yearmth}, \code{zoo::yearqtr}, and
\code{nanotime}.
For a \code{tbl_ts} of regular interval,
a choice of index representation has to be made. For example, a monthly data
should correspond to time index created by \link{yearmonth} or \code{zoo::yearmth},
instead of \code{Date} or \code{POSIXct}. Because months in a year ensures the regularity,
12 months every year. However, if using \code{Date}, a month contains days ranging
from 28 to 31 days, which results in irregular time space. This is also applicable
to year-week and year-quarter.

Since the \strong{tibble} that underlies the \strong{tsibble} only accepts a 1d atomic
vector or a list, a \code{tbl_ts} doesn't accept \code{POSIXlt} and \code{timeDate} columns.
}

\section{Key}{

Key variable(s) together with the index uniquely identifies each record. And
the key also imposes the structure on a tsibble, which can be created via the
\link{id} function as identifiers:
\itemize{
\item None: an implicit variable \code{id()} resulting a univariate time series.
\item A single variable: an explicit variable. For example, \code{data(pedestrian)}
uses the \code{id(Sensor)} column as the key.
\item Nested variables: a nesting of one variable under another. For example,
\code{data(tourism)} contains two geographical locations: \code{Region} and \code{State}.
\code{Region} is the lower level than \code{State} in Australia; in other words, \code{Region}
is nested into \code{State}, which naturally forms a hierarchy. A vertical bar (\code{|})
is used to describe this nesting relationship, and thus \code{Region} | \code{State}.
Alternatively, a forward slash (\code{/}) expresses the equivalent hierarchy but
in a reverse order, for example \code{State} / \code{Region}.
In theory, nesting can involve infinite levels, so is \code{tsibble}.
\item Crossed variables: a crossing of one variable with another. For example,
the geographical locations are crossed with the purpose of visiting (\code{Purpose})
in the \code{data(tourism)}. A comma (\code{,}) is used to indicate this crossing
relationship. Nested and crossed variables can be combined, such as
\code{data(tourism)} using \code{id(Region | State, Purpose)}.
}

These key variables describe the data structure, which will prove useful in
data visualisation and statistical modelling.
}

\section{Interval}{

The \link{interval} function returns the interval associated with the tsibble.
\itemize{
\item Regular: the value and its time unit including "nanosecond", "microsecond",
"millisecond", "second", "minute", "hour", "day", "week", "month", "quarter",
"year". An unrecognisable time interval is labelled as "unit".
\item Irregular: \code{as_tsibble(regular = FALSE)} gives the irregular tsibble. It is
marked with \code{!}.
\item Unknown: if there is only one entry for each key variable, the interval
cannot be determined (\code{?}).
}

An interval is obtained based on the corresponding index representation:
\itemize{
\item integer/numeric: either "unit" or "year"
\item \code{yearquarter}/\code{yearqtr}: "quarter"
\item \code{yearmonth}/\code{yearmth}: "month"
\item \code{yearweek}: "week"
\item \code{Date}: "day"
\item \code{POSIXct}: "hour", "minute", "second", "millisecond", "microsecond"
\item \code{nanotime}: "nanosecond"
}
}

\examples{
# create a tsibble w/o a key ----
tsibble(
  date = as.Date("2017-01-01") + 0:9,
  value = rnorm(10)
)

# create a tsibble with one key ----
tsibble(
  qtr = rep(yearquarter("201001") + 0:9, 3),
  group = rep(c("x", "y", "z"), each = 10),
  value = rnorm(30),
  key = id(group)
)

}
\seealso{
\link{build_tsibble}
}
