% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{update_tsibble}
\alias{update_tsibble}
\title{Update key and index for a tsibble}
\usage{
update_tsibble(x, key = NULL, index = NULL, regular = NULL,
  validate = TRUE)
}
\arguments{
\item{x}{A tsibble.}

\item{key}{Variable(s) that define unique time indices, used in conjunction
with the helper \code{\link[=id]{id()}}. If a univariate time series (without an explicit key),
simply call \code{id()}.}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The
interval is determined by the greatest common divisor of index column, if \code{TRUE}.}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables leads to unique time indices (i.e. a valid tsibble). If you
are sure that it's a valid input, specify \code{FALSE} to skip the checks.}
}
\description{
Update key and index for a tsibble
}
\details{
Default \code{NULL} inherits attributes from \code{x}.
}
\examples{
pedestrian \%>\% 
  group_by_key() \%>\% 
  mutate(Hour_Since = Date_Time - min(Date_Time)) \%>\% 
  update_tsibble(index = Hour_Since)
}
