% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{interval_pull}
\alias{interval_pull}
\title{Pull time interval from a vector}
\usage{
interval_pull(x)
}
\arguments{
\item{x}{A vector of \code{POSIXct}, \code{Date}, \code{yearweek}, \code{yearmonth}, \code{yearquarter},
\code{difftime}/\code{hms}, \code{ordered}, \code{integer}, \code{numeric}, and \code{nanotime}.}
}
\value{
an "interval" class (a list) includes "year",
"quarter", "month", "week", "day", "hour", "minute", "second", "millisecond",
"microsecond", "nanosecond", "unit".
}
\description{
\Sexpr[results=rd, stage=render]{tsibble:::lifecycle("stable")}

Assuming regularly spaced time, the \code{interval_pull()} returns a list of time
components as the "interval" class.
}
\details{
Extend tsibble to support custom time indexes by defining S3 generics
\code{index_valid()} and \code{interval_pull()} for them.
}
\examples{
x <- seq(as.Date("2017-10-01"), as.Date("2017-10-31"), by = 3)
interval_pull(x)
}
