% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-pre-w.R
\name{mass_pre_w}
\alias{mass_pre_w}
\title{Precomputes several values used on MASS}
\usage{
mass_pre_w(data, query = NULL, window_size, weight)
}
\arguments{
\item{data}{a \code{vector} or a \code{matrix} of \code{numeric}. Reference Time Series.}

\item{query}{a \code{vector} or a \code{matrix} of \code{numeric}. Query Time Series (default is \code{NULL}).}

\item{window_size}{an \code{int}. Sliding window size.}

\item{weight}{a \code{vector} of \code{numeric} with the same length of the \code{window_size}.}
}
\value{
Returns \code{window_size}, \code{data_fft}, \code{data_size}, \code{data_mean}, \code{data_sd}, \code{data_pre}, \code{weight}
}
\description{
Precomputes several values used on MASS
}
\examples{
w <- mp_toy_data$sub_len
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 1]
weight <- c(rep(1, mp_toy_data$sub_len / 3), rep(0.5, mp_toy_data$sub_len / 3),
rep(1, mp_toy_data$sub_len / 3))

pre <- tsmp:::mass_pre_w(ref_data, query_data, w, weight)

dp <- list()
for (i in 1:(pre$data_size - w + 1)) {
  dp[[i]] <- tsmp:::mass_weighted(
    query_data[i:(i - 1 + w)], pre$window_size, pre$data_fft, pre$data_size,
    pre$data_mean, pre$data_sd, pre$data_pre, pre$weight
  )
}
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance.
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_weighted]{mass_weighted()}} for using precomputed values.
}
\keyword{internal}
