% Generated by roxygen2 (4.0.1): do not edit by hand
\name{triplicated}
\alias{triplicated}
\title{Find Values That Are Repeated At Least Thrice}
\usage{
triplicated(x, ..., fromLast = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{fromLast}{A logical indicating if triplication should be considered from
the reverse side, i.e., the two last (or rightmost) of identical
elements would return \code{FALSE}.}

\item{...}{Other optional arguments are ignored.}
}
\description{
Finds values that are repeated at least three times in a vector.
}
\details{
Returns a logical vector that is \code{TRUE} when it runs into
  any but the first or second occurrences of a value, analogous
  to \code{\link[base]{duplicated}}.
}
\examples{
triplicated(c(NA, 1:3, 3, 4:6, 3, NA, 4, 3))
}
\seealso{
\code{\link[base]{duplicated}}
}
\keyword{repeat,}
\keyword{repeated}
\keyword{triplicate,}
\keyword{triplicated,}

