% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tuplicate}
\alias{tuplicate}
\title{Find n-Replicated Elements}
\usage{
tuplicate(x, n)
}
\arguments{
\item{x}{A vector.}

\item{n}{An integer.}
}
\description{
Finds elements that occur exactly n times in a vector.
}
\details{
Returns the n-replicated elements in the same order that they would be
  returned in a call to \code{\link{orphan}}.  This fundamentally
  differs from \code{\link{tuplicated}}, which returns
  a logical vector that is \code{TRUE} when it runs into any but
  the \code{(n-1)}-st and fewer occurrences of an element
  (and is therefore dependent on the direction of testing of the vector).
}
\examples{
x <- c(NA, 1:3, 4:5, rep(6, 6), 3, NA, 4, 3, 3)
lapply(2:6, function(X) { tuplicate(x, X) })
}
\seealso{
\code{\link{duplicate}}
}
\keyword{match}
\keyword{n-replicate,}
\keyword{n-replicated,}
\keyword{repeat,}
\keyword{repeated,}

