% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvIRF.R
\name{tvIRF}
\alias{tvIRF}
\alias{tvirf-class}
\alias{tvirf.}
\alias{tvIRF.tvvar}
\title{Time-Varying Impulse Response Function}
\usage{
tvIRF(x, ...)

\method{tvIRF}{tvvar}(x, impulse = NULL, response = NULL, n.ahead = 10,
  ortho = TRUE, ortho.cov = c("tv", "const"), bw.cov = NULL,
  cumulative = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{tvvar}.}

\item{...}{Other parameters passed to specific methods.}

\item{impulse}{A character vector of the impulses, default is all variables.}

\item{response}{A character vector of the responses, default is all variables.}

\item{n.ahead}{Integer specifying the steps.}

\item{ortho}{Logical, if TRUE (the default) the orthogonalised IRF is computed.}

\item{ortho.cov}{A character indicating if the covariance matrix for the orthogonal tvIRF should
be estimated as a constant or time varying. Either 'const' or 'tv' (default). This parameter is used
only when ortho = TRUE.}

\item{bw.cov}{A scalar (optional) with the bandwidth to estimate the errors
variance-covariance matrix. If left NULL, it is estimated.}

\item{cumulative}{Logical, if TRUE the cumulated impulse response coefficients are computed.
Default is FALSE.}
}
\value{
\code{tvIRF} returns and object of class \code{tvirf} with the following components:
\item{irf}{An array dim = c(obs x number of response variables x number of impulse variables x
number steps).}
\item{Lower}{An array with the lower confidence line, if calculated.}
\item{Upper}{An array with the upper confidence line, if calculated.}
\item{response}{A character, a number of a vector with the names or positions of the response(s)
variable(s).}
\item{impulse}{A character, a number of a vector with the names or positions of the impulse(s)
variable(s).}
\item{x}{A object of class \code{tvvar}}.
\item{n.ahead}{Number of ahead impulse response functions.}
\item{ortho}{Logical, orthogonal or not impuluse response function.}
\item{ortho.cov}{Character, either 'const' or 'tv' (default). This parameter is used when the orthogonal
tv-IRF is calculated. The default is using an error time-varying variance-covariance.}
\item{bw.cov}{A scalar with the bandwidth to estimate the errors variance-covariance matrix. If NULL,
it is calculated by cross-validation.}
\item{cumulative}{Logical, if TRUE the cumulated impulse response coefficients are computed. Default is FALSE.}
\item{level}{Numeric, confidence interval range. The default is zero.}
\item{runs}{Number of bootstrap replications.}
\item{tboot}{Type of bootstrap.}
\item{BOOT}{List with all bootstrap replications of \code{tvirf}, if done.}
}
\description{
Computes the time-varying impulse response coefficients of an object of class \code{tvvar},  obtained
with function tvVAR for n.ahead steps.
}
\seealso{
\code{\link{CI}}, \code{\link{plot}}
}
