% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watch.R
\name{typr_watch}
\alias{typr_watch}
\alias{typr_watch_stop}
\title{Watch a Typst document}
\usage{
typr_watch(
  input = NULL,
  output_file = NULL,
  output_format = c("pdf", "png", "svg", "html"),
  typst_args = NULL
)

typr_watch_stop()
}
\arguments{
\item{input}{either a path to a \code{.typ} file or text to use as the file}

\item{output_file}{file to output to}

\item{output_format}{format to use. One of \code{c('pdf', 'png', 'svg', 'html')},}

\item{typst_args}{Additional arguments to pass to Typst. Can be listed with \code{typr_help('watch')}}
}
\value{
a path to the created file
}
\description{
Watch a Typst document
}
\examples{
\dontshow{if (has_any_typst()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tf <- fs::file_temp(ext = 'typ')
writeLines(text = '= test', con = tf)
typr_watch(tf)
writeLines(text = c('= test', 'hello'), con = tf)
\dontshow{\}) # examplesIf}
}
