% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{typr_query}
\alias{typr_query}
\title{Query within a Typst file}
\usage{
typr_query(
  input = NULL,
  selector = NULL,
  typst_args = NULL,
  as_json = !rlang::is_installed("jsonlite")
)
}
\arguments{
\item{input}{a path to a \code{.typ} file}

\item{selector}{a string to search for, e.g. a \code{"<label>"}}

\item{typst_args}{Additional arguments to pass to Typst. Can be listed with \code{typr_help('query')}}

\item{as_json}{if \code{TRUE}, return a list, otherwise a character string}
}
\value{
a length one character with json syntax if \code{!as_json}, otherwise a list
}
\description{
Query within a Typst file
}
\examples{
\dontshow{if (has_any_typst()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tf <- fs::file_temp(ext = 'typ')
writeLines(text = '= test <lbl>\n', con = tf)
typr_query(input = tf, selector = '<lbl>')
\dontshow{\}) # examplesIf}
}
