% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{fitGSMAR}
\alias{fitGSMAR}
\title{Estimate Gaussian or Student's t Mixture Autoregressive model}
\usage{
fitGSMAR(data, p, M, model = c("GMAR", "StMAR", "G-StMAR"),
  restricted = FALSE, constraints = NULL, conditional = TRUE,
  parametrization = c("intercept", "mean"), ncalls = round(10 + 9 *
  log(sum(M))), ncores = min(ncalls, parallel::detectCores()),
  maxit = 300, printRes = TRUE, runTests = FALSE, ...)
}
\arguments{
\item{data}{a numeric vector class \code{'ts'} object containing the data. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the order of AR coefficients.}

\item{M}{\describe{
  \item{For \strong{GMAR} and \strong{StMAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMAR} model:}{a size (2x1) vector specifying the number of \emph{GMAR-type} components \code{M1} in the
   first element and \emph{StMAR-type} components \code{M2} in the second. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{model}{is "GMAR", "StMAR" or "G-StMAR" model considered? In G-StMAR model the first \code{M1} components
are \emph{GMAR-type} and the rest \code{M2} components are \emph{StMAR-type}.}

\item{restricted}{a logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes.}

\item{constraints}{specifies linear constraints applied to the autoregressive parameters.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{C_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{C}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
Symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the nominal order of AR coefficients is
alway \code{p} for all regimes.
Ignore or set to \code{NULL} if applying linear constraints is \strong{not} desired.}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function should be used.}

\item{parametrization}{is the model parametrized with the "intercepts" \eqn{\phi_{m,0}} or
"means" \eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}?}

\item{ncalls}{a positive integer specifying how many rounds of estimation should be conducted.
The estimation results may vary from round to round because of multimodality of the log-likelihood function
and randomness associated with the genetic algorithm.}

\item{ncores}{a positive integer specifying the number of cores to be used in the estimation process.
Default is that the number of available cores is detected with \code{parallel::detectCores} and all of them are used.}

\item{maxit}{maximum number of iterations in the variable metric algorithm.}

\item{printRes}{should the estimation results be printed?}

\item{runTests}{should quantile residuals tests be performed after the estimation?}

\item{...}{additional settings passed to the function \code{GAfit} employing the genetic algorithm.}
}
\value{
Returns an object of class \code{'gsmar'} defining the estimated GMAR, StMAR or G-StMAR model. The returned object contains
  empirical mixing weights, conditional means and variances, quantile residuals, and quantile residual test results if the tests were performed.
  Note that the first p observations are taken as the initial values so mixing weights, conditional moments and qresiduals start from the p+1:th observation
  (interpreted as t=1). In addition, the returned object contains the estimates and log-likelihood values from all the estimation rounds.
  The estimated parameter vector can be obtained at \code{gsmar$params} (and the corresponding approximate standard errors at \code{gsmar$std_errors})
  and it's...
 \describe{
   \item{For \strong{non-restricted} models:}{
     \describe{
       \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
         \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
       \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
       \item{For \strong{G-StMAR} model:}{Size \eqn{(M(p+3)+M2-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
         \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M}}).}
       \item{With \strong{linear constraints}:}{Replace the vectors \strong{\eqn{\phi_{m}}} with vectors \strong{\eqn{\psi_{m}}} and provide a  list of constraint
         matrices \strong{C} that satisfy \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
         \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
     }
   }
   \item{For \strong{restricted} models:}{
     \describe{
       \item{For \strong{GMAR} model:}{Size \eqn{(3M+p-1x1)} vector \strong{\eqn{\theta}}\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1})}, where \strong{\eqn{\phi}}=\eqn{(\phi_{1},...,\phi_{M})}.}
       \item{For \strong{StMAR} model:}{Size \eqn{(4M+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M})}.}
       \item{For \strong{G-StMAR} model:}{Size \eqn{(3M+M2+p-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=(\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\phi}}\eqn{,
         \sigma_{1}^2,...,\sigma_{M}^2,\alpha_{1},...,\alpha_{M-1}, \nu_{M1+1},...,\nu_{M})}.}
       \item{With \strong{linear constraints}:}{Replace the vector \strong{\eqn{\phi}} with vector \strong{\eqn{\psi}} and provide a constraint matrix
         \strong{\eqn{C}} that satisfies \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where
         \strong{\eqn{\psi}}\eqn{=(\psi_{1},...,\psi_{q})}.}
     }
   }
 }
 Symbol \eqn{\phi} denotes an AR coefficient, \eqn{\sigma^2} a variance, \eqn{\alpha} a mixing weight and \eqn{\nu} a degrees of
 freedom parameter. If \code{parametrization=="mean"} just replace each intercept term \eqn{\phi_{m,0}} with regimewise mean
 \eqn{\mu_m = \phi_{m,0}/(1-\sum\phi_{i,m})}. In the \strong{G-StMAR} model the first \code{M1} components are \emph{GMAR-type}
 and the rest \code{M2} components are \emph{StMAR-type}.
 Note that in the case \strong{M=1} the parameter \eqn{\alpha} is dropped, and in the case of \strong{StMAR} or \strong{G-StMAR} model
 the degrees of freedom parameters \eqn{\nu_{m}} have to be larger than \eqn{2}.
}
\description{
\code{fitGSMAR} estimates GMAR, StMAR or G-StMAR model in two phases: in the first phase, the genetic algorithm is employed
  to find starting values for the gradient based variable metric algorithm (also known as quasi-Newton method). In the second phase, the
  variable metric algorithm accurately converges to a nearby local maximum or saddle point. Parallel computing is used to perform multiple
  rounds of estimations in parallel.
}
\details{
Because of complexity and multimodality of the log-likelihood function, it's \strong{not guaranteed} that the estimation
 algorithm will end up in the global maximum point. It's often expected that most of the estimation rounds will end up in
 some local maximum point instead, and therefore a number of estimation rounds is required for reliable results. Because
 of the nature of the models, the estimation may fail particularly in the cases where the number of mixture components is
 chosen too large.

 If the iteration limit in the variable metric algorithm (\code{maxit}) is reached, one can continue the estimation by iterating
 more with the function \code{iterate_more}.

 The genetic algorithm is mostly based on the description by \emph{Dorsey and Mayer (1995)}. It uses (slightly modified)
 individually adaptive crossover and mutation rates described by \emph{Patnaik and Srinivas (1994)} and employs (50\%)
 fitness inheritance discussed by \emph{Smith, Dike and Stegmann (1995)}. Large (in absolute value) but stationary
 AR parameter values are generated with the algorithm proposed by Monahan (1984).

 The variable metric algorithm (or quasi-Newton method, Nash (1990, algorithm 21)) used in the second phase is implemented with function the
 \code{optim} from the package \code{stats}.

 Some mixture components of the StMAR model may sometimes get very large estimates for degrees of freedom parameters. Such estimates may,
 for example, cause computing the quantile residual tests to fail. However, such mixture components are very much similar to the components
 of the GMAR model. It's hence advisable to further estimate a G-StMAR model by allowing the mixture components with large degrees of freedom
 parameter estimates to be GMAR type.
}
\section{S3 methods}{

 The following S3 methods are supported for class \code{'gsmar'} objects: \code{print}, \code{summary}, \code{plot},
 \code{logLik}, \code{residuals}.
}

\section{Suggested packages}{

 For faster evaluation of the quantile residuals of StMAR and G-StMAR models, install the suggested package "gsl".
 Note that for large StMAR and G-StMAR models with large data the evaluations of the quantile residual tests may take
 significantly long time without the package "gsl".
}

\examples{
\donttest{
# These are long running examples and use parallel computing

# GMAR model
fit12 <- fitGSMAR(data=logVIX, p=1, M=2, model="GMAR")
fit12
summary(fit12)
plot(fit12)

# Restricted GMAR model
fit12r <- fitGSMAR(logVIX, 1, 2, model="GMAR", restricted=TRUE,
 parametrization="mean", ncalls=10)
fit12r
summary(fit12r)

# Non-mixture version of StMAR model
fit11t <- fitGSMAR(logVIX, 1, 1, model="StMAR", ncores=1, ncalls=1)
fit11t

# StMAR model
fit12t <- fitGSMAR(logVIX, 1, 2, model="StMAR")
fit12t

# G-StMAR model with one GMAR type and one StMAR type regime
fit12gs <- fitGSMAR(logVIX, 1, M=c(1, 1), model="G-StMAR")
fit12gs

# Restricted G-StMAR model
fit12gsr <- fitGSMAR(logVIX, 1, c(1, 1), model="G-StMAR", restricted=TRUE)
fit12gsr

# The following three examples demonstrate how to apply linear constraints
# to the AR parameters.

# GMAR model that is a mixture of AR(1) and such AR(3) that the
# second AR coeffiecient is constrained to zero.
constraints <- list(matrix(c(1, 0, 0, 0, 0, 1), ncol=2), as.matrix(c(1, 0, 0)))
fit32c <- fitGSMAR(logVIX, 3, 2, constraints=constraints)
fit32c

# Such constrained StMAR(3, 1) model that the second order AR coefficient
# is constrained to zero.
constraints <- list(matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
fit31tc <- fitGSMAR(logVIX, 3, 1, model="StMAR", constraints=constraints)
fit31tc

# Such StMAR(3, 2) model that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
fit32trc <- fitGSMAR(logVIX, 3, 2, model="StMAR", restricted=TRUE,
                     constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
fit32trc
}
}
\references{
\itemize{
   \item Dorsey R. E. and Mayer W. J. 1995. Genetic algorithms for estimation problems with multiple optima,
         nondifferentiability, and other irregular features. \emph{Journal of Business & Economic Statistics},
         \strong{13}, 53-66.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
         \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
         arXiv:1805.04010 \strong{[econ.EM]}.
   \item Monahan J.F. 1984. A Note on Enforcing Stationarity in Autoregressive-Moving Average Models.
         \emph{Biometrica} \strong{71}, 403-404.
   \item Nash J. 1990. Compact Numerical Methods for Computers. Linear algebra and Function Minimization.
         \emph{Adam Hilger}.
   \item Patnaik L.M. and Srinivas M. 1994. Adaptive Probabilities of Crossover and Mutation in Genetic Algorithms.
         \emph{Transactions on Systems, Man and Cybernetics} \strong{24}, 656-667.
   \item Smith R.E., Dike B.A., Stegmann S.A. 1995. Fitness inheritance in genetic algorithms.
         \emph{Proceedings of the 1995 ACM Symposium on Applied Computing}, 345-350.
   \item There are currently no published references for the G-StMAR model, but it's a straightforward generalization with
         theoretical properties similar to the GMAR and StMAR models.
 }
}
\seealso{
\code{\link{GSMAR}}, \code{\link{iterate_more}}, , \code{\link{stmar_to_gstmar}}, \code{\link{add_data}},
 \code{\link{swap_parametrization}}, \code{\link{get_gradient}}, \code{\link{simulateGSMAR}}, \code{\link{predict.gsmar}},
  \code{\link{diagnosticPlot}}, \code{\link{quantileResidualTests}}, \code{\link{condMoments}}, \code{\link{uncondMoments}}
}
