% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_bluedjinn.R
\name{xyz2tif}
\alias{xyz2tif}
\title{Read and Convert xyz DEM/DSM Data as typically provided by the Authorities.}
\usage{
xyz2tif(xyzFN = NULL, epsgCode = "25832")
}
\arguments{
\item{xyzFN}{ASCII tect file with xyz values}

\item{epsgCode}{"25832"}
}
\description{
Read xyz data and generate a Raster* object.
}
\examples{
\dontrun{
##- libraries
require(uavRst)
owd <- getwd()
setwd(tempdir())
##- get typical xyz DEM data in this case from the Bavarian authority 
utils::download.file("http://www.ldbv.bayern.de/file/zip/10430/DGM_1_ascii.zip",
                    "testdata.zip")
file<- unzip("testdata.zip",list = TRUE)$Name[2]
unzip("testdata.zip",files = file,  overwrite = TRUE)
##- show structure
head(read.table(file))
##- create tiff file
##- NOTE  for creating a geotiff you have to provide the correct EPSG code from the meta data
xyz2tif(file,epsgCode = "31468")

##- visualize it
raster::plot(raster::raster(file))
setwd(owd)
}

}
