% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_fetch_nca_columns}
\alias{system_fetch_nca_columns}
\title{Columns in NCA Analysis}
\usage{
system_fetch_nca_columns(cfg, analysis_name = "analysis")
}
\arguments{
\item{cfg}{ubiquity system object}

\item{analysis_name}{string containing the name of the NCA analysis (default \code{'analysis'})}
}
\value{
list with the following elements:
\itemize{
   \item \code{isgood} Boolean variable to identify if the function
       executed properly (\code{TRUE}) or if there were any errors
       (\code{FALSE})
   \item \code{NCA_col_summary} dataframe with the columns from the
       analysis in \code{analysis_name} (\code{col_name} - NCA short name,
       \code{from} - where the parameter was derived from, \code{label} - verbose
       text label for the column, and \code{description}, verbose text description
       of the parameter.
   \item \code{len_NCA_col}     maximum length of the \code{col_name} column
   \item \code{len_from}        maximum length of the \code{from} column
   \item \code{len_label}       maximum length of the \code{label} column
   \item \code{len_description} maximum length of the \code{description} column
}
}
\description{
Show the columns available in a given NCA analysis
}
\seealso{
Vignette on NCA (\code{\link{system_nca_parameters_meta}})
}
