% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomPois.R
\name{stan_multinomPois}
\alias{stan_multinomPois}
\title{Fit the Multinomial-Poisson Mixture Model}
\usage{
stan_multinomPois(
  formula,
  data,
  prior_intercept_state = normal(0, 5),
  prior_coef_state = normal(0, 2.5),
  prior_intercept_det = logistic(0, 1),
  prior_coef_det = logistic(0, 1),
  prior_sigma = gamma(1, 1),
  ...
)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and abundance in that order}

\item{data}{A \code{\link{unmarkedFrameMPois}} object}

\item{prior_intercept_state}{Prior distribution for the intercept of the
state (abundance) model; see \code{?priors} for options}

\item{prior_coef_state}{Prior distribution for the regression coefficients of
the state model}

\item{prior_intercept_det}{Prior distribution for the intercept of the
detection probability model}

\item{prior_coef_det}{Prior distribution for the regression coefficients of
the detection model}

\item{prior_sigma}{Prior distribution on random effect standard deviations}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitMultinomPois} object describing the model fit.
}
\description{
This function fits the multinomial-Poisson mixture model, useful for
data collected via survey methods such as removal or double observer sampling.
}
\examples{
\donttest{
data(ovendata)
ovenFrame <- unmarkedFrameMPois(ovendata.list$data,
                                siteCovs=ovendata.list$covariates,
                                type="removal")

oven_fit <- stan_multinomPois(~1~scale(ufc), ovenFrame, chains=3, iter=300)
}

}
\seealso{
\code{\link{multinomPois}}, \code{\link{unmarkedFrameMPois}}
}
