% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef,ubmsFit-method}
\alias{ranef,ubmsFit-method}
\alias{ranef}
\title{Extract Random Effects}
\usage{
\S4method{ranef}{ubmsFit}(object, submodel, summary = FALSE, ...)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{submodel}{The name of the submodel, as a character string, for
which to generate the random effects}

\item{summary}{If \code{TRUE}, calculate mean, SD, and 95% uncertainty interval
for each random effect term}

\item{...}{Currently ignored}
}
\value{
If \code{summary=FALSE}, a list of random effect values; if
 \code{TRUE}, a data frame with columns for random effect mean, SD, and
 95% uncertainty interval lower and upper bounds.
}
\description{
Extract random effects from a \code{ubmsFit} model. Note that this function
works like \code{ranef} for \code{merMod} objects from \code{lme4}, not like
\code{ranef} for \code{unmarkedFit} objects. To get functionality similar
to that of \code{unmarkedFit}, use \code{posterior_predict}.
}
\seealso{
\code{\link[lme4]{ranef}}, \code{\link{posterior_predict}}
}
