% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insertFigureCaption.R,
%   R/insertNumberedCaption.R, R/insertTableCaption.R
\name{insertFigureCaption}
\alias{insertFigureCaption}
\alias{insertNumberedCaption}
\alias{insertTableCaption}
\title{Insert numbered caption}
\usage{
insertFigureCaption(
  captionText = "",
  captionName = "fig.cap",
  prefix = getOption(paste0(optionName, "_prefix"), "Figure \%s: "),
  suffix = getOption(paste0(optionName, "_suffix"), ""),
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = NULL
)

insertNumberedCaption(
  captionText = "",
  captionName = "fig.cap",
  prefix = getOption(paste0(optionName, "_prefix"), "Figure \%s: "),
  suffix = getOption(paste0(optionName, "_suffix"), ""),
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = NULL
)

insertTableCaption(
  captionText = "",
  captionName = "tab.cap",
  prefix = getOption(paste0(optionName, "_prefix"), "Table \%s: "),
  suffix = getOption(paste0(optionName, "_suffix"), ""),
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = NULL
)
}
\arguments{
\item{captionText}{The text of the caption.}

\item{captionName}{The name of the caption; by default, for tables,
"\code{tab.cap}".}

\item{prefix, suffix}{The prefix and suffix texts; \code{\link[base:sprintf]{base::sprintf()}} is used
to insert the number in the position taken up by \verb{\\\%s}.}

\item{optionName}{The name of the option to use to save the number counter.}

\item{resetCounterTo}{If a numeric value, the counter is reset to that value.}
}
\value{
The caption in a character vector.
}
\description{
These functions can be used to manually insert a numbered caption. These
functions have been designed to work well with \code{\link[=setFigCapNumbering]{setFigCapNumbering()}} and
\code{\link[=setTabCapNumbering]{setTabCapNumbering()}}. This is useful when
inserting figures or tables in an RMarkdown document when you
use automatic caption numbering for \code{knitr} chunks, but are inserting a
table or figure that isn't produced in a \code{knitr} chunk while
still retaining the automatic numbering. \code{insertNumberedCaption()} is the
general-purpose function; you will typically only use \code{insertFigureCaption()}
and \code{insertTableCaption()}.
}
\examples{
insertNumberedCaption("First caption");
insertNumberedCaption("Second caption");
sectionNumber <- 12;
insertNumberedCaption("Third caption",
                      prefix = paste0("Table ",
                                      sectionNumber,
                                      ".\%s: "));
}
