% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_is_cov}
\alias{umx_is_cov}
\title{umx_is_cov}
\usage{
umx_is_cov(data = NULL, boolean = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{dataframe to test}

\item{boolean}{whether to return the type ("cov") or a boolean (default = string)}

\item{verbose}{How much feedback to give (default = FALSE)}
}
\value{
- "raw", "cor", or "cov", or, if boolean= T, then T | F
}
\description{
test if a data frame or matrix is cov or cor data, or is likely to be raw...
}
\examples{
df = cov(mtcars)
umx_is_cov(df)
df = cor(mtcars)
umx_is_cov(df)
umx_is_cov(df, boolean = TRUE)
umx_is_cov(mtcars, boolean = TRUE)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxValues}}

Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_print}};
  \code{\link{umx_rename}}; \code{\link{umx_reorder}};
  \code{\link{umx_rot}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

