% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_get_checkpoint}
\alias{umx_get_checkpoint}
\title{umx_get_checkpoint}
\usage{
umx_get_checkpoint(model = NULL)
}
\arguments{
\item{model}{an optional model to get options from}
}
\value{
- NULL
}
\description{
get the checkpoint status for a model or global options
}
\examples{
umx_get_checkpoint() # current global default
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m1 = umx_set_checkpoint(interval = 2, model = m1)
umx_get_checkpoint(model = m1)
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Get and set: \code{\link{umx_get_cores}},
  \code{\link{umx_get_optimizer}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}}
}

