% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_fix_first_loadings}
\alias{umx_fix_first_loadings}
\title{umx_fix_first_loadings}
\usage{
umx_fix_first_loadings(model, latents = NULL, at = 1)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to set}

\item{latents}{(If NULL then all latentVars in model)}

\item{at}{(Default = 1)}
}
\value{
- \code{\link{mxModel}}
}
\description{
Fix the loading of the first path from each latent at selected value (default = 1).
}
\examples{
require(umx)
data(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
 manifestVars = names(demoOneFactor),
 latentVars = "g",
	mxPath(from = "g", to = names(demoOneFactor)),
	mxPath(from = names(demoOneFactor), arrows = 2),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umx_fix_first_loadings(m1)
umx_show(m1) # variance of g is fixed at 1
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Model Building Functions: \code{\link{umxDiagnose}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxModify}}, \code{\link{umxPath}},
  \code{\link{umxRAM}}, \code{\link{umxRun}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}}, \code{\link{umx_fix_latents}},
  \code{\link{umx}}
}

