% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_names}
\alias{umx_names}
\title{umx_names}
\usage{
umx_names(df, pattern = ".*", ignore.case = TRUE, perl = FALSE,
  value = TRUE, fixed = FALSE, useBytes = FALSE, invert = FALSE)
}
\arguments{
\item{df}{dataframe to get names from}

\item{pattern}{= "find.*"}

\item{ignore.case}{default = TRUE (opposite default to grep)}

\item{perl}{= FALSE}

\item{value}{= default = TRUE (opposite default to grep)}

\item{fixed}{= FALSE}

\item{useBytes}{= FALSE}

\item{invert}{= FALSE}
}
\value{
- vector of matches
}
\description{
Convenient equivalent of grep("fa[rl].*", names(df), value = TRUE, ignore.case = TRUE)
Can handle dataframe (uses names), model (uses parameter names), or a vector of strings.
}
\examples{
umx_names(mtcars, "mpg") #"mpg" "cyl" "disp" "hp" "drat" "wt" "qsec" "vs" "am" "gear" "carb"
umx_names(mtcars, "^d") # "disp", drat
umx_names(mtcars, "r[ab]") # "drat", "carb"
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_grep}},
  \code{\link{umx_msg}}, \code{\link{umx_paste_names}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx_rename}}, \code{\link{umx}}
}

