% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummary.MxModel}
\alias{umxSummary.MxModel}
\title{umxSummary.MxModel}
\usage{
\method{umxSummary}{MxModel}(model, refModels = NULL,
  showEstimates = c("raw", "std", "none", "both", "list of column names"),
  digits = 2, report = c("1", "table", "html"), filter = c("ALL", "NS",
  "SIG"), SE = TRUE, RMSEA_CI = FALSE, matrixAddresses = FALSE, ...)
}
\arguments{
\item{model}{The \code{\link{mxModel}} whose fit will be reported}

\item{refModels}{Saturated models if needed for fit indices (see example below:
If NULL will be competed on demand. If FALSE will not be computed. Only needed for raw data.}

\item{showEstimates}{What estimates to show. By default, the raw estimates are shown 
(Options = c("raw", "std", "both", "none", "list of column names").}

\item{digits}{How many decimal places to report (default = 2)}

\item{report}{If "html", then show results in browser ("1", "table", "html")}

\item{filter}{whether to show significant paths (SIG) or NS paths (NS) or all paths (ALL)}

\item{SE}{Whether to compute SEs... defaults to TRUE. In rare cases, you might need to turn off to avoid errors.}

\item{RMSEA_CI}{Whether to compute the CI on RMSEA (Defaults to FALSE)}

\item{matrixAddresses}{Whether to show "matrix address" columns (Default = FALSE)}

\item{...}{Other parameters to control model summary}
}
\value{
- parameterTable returned invisibly, if estimates requested
}
\description{
Report the fit of a model in a compact form suitable for a journal. Emits a "warning" 
when model fit is worse than accepted criterion (TLI >= .95 and RMSEA <= .06; (Hu & Bentler, 1999; Yu, 2002).
}
\details{
notes on CIs and Identification
Note, the conventional standard errors reported by OpenMx are used to produce the CIs you see in umxSummary
These are used to derive confidence intervals based on the formula 95%CI = estimate +/- 1.96*SE)

Sometimes they appear NA. This often indicates a model which is not identified (see\url{http://davidakenny.net/cm/identify.htm}).
This can include empirical under-identification - for instance two factors
that are essentially identical in structure.

A signature of this would be paths estimated at or close to
zero. Fixing one or two of these to zero may fix the standard error calculation, 
and alleviate the need to estimate likelihood-based or bootstrap CIs

If factor loadings can flip sign and provide identical fit, this creates another form of 
under-identification and can break confidence interval estimation, but I think
Fixing a factor loading to 1 and estimating factor variances can help here
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor",
	data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
umxSummary(m1, showEstimates = "std")
# output as latex
umx_set_table_format("latex")
umxSummary(m1, showEstimates = "std")
umx_set_table_format("markdown")
# output as raw
umxSummary(m1, show = "raw")
m1 <- mxModel(m1,
  mxData(demoOneFactor[1:100,], type = "raw"),
  umxPath(mean = manifests),
  umxPath(mean = latents, fixedAt = 0)
)
m1 <- mxRun(m1)
umxSummary(m1, showEstimates = "std", filter = "NS")
}
\references{
- Hu, L., & Bentler, P. M. (1999). Cutoff criteria for fit indexes in covariance 
 structure analysis: Coventional criteria versus new alternatives. Structural Equation Modeling, 6, 1-55. 

 - Yu, C.Y. (2002). Evaluating cutoff criteria of model fit indices for latent variable models
 with binary and continuous outcomes. University of California, Los Angeles, Los Angeles.
 Retrieved from \url{http://www.statmodel.com/download/Yudissertation.pdf}
\url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxRun}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxSummaryACE}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
