% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmuLabel_RAM_Model}
\alias{xmuLabel_RAM_Model}
\title{xmuLabel_RAM_Model (not a user function)}
\usage{
xmuLabel_RAM_Model(model, suffix = "", labelFixedCells = TRUE,
  overRideExisting = FALSE, verbose = FALSE, name = NULL)
}
\arguments{
\item{model}{a RAM mxModel to label}

\item{suffix}{a string to append to each label}

\item{labelFixedCells}{Whether to labelFixedCells (Default TRUE)}

\item{overRideExisting}{Whether to overRideExisting (Default FALSE)}

\item{verbose}{how much feedback to give}

\item{name}{Add optional name parameter to rename returned model (default = leave it along)}
}
\value{
- The labeled \code{\link{mxModel}}
}
\description{
This function will label all the free parameters in a RAM \code{\link{mxModel}}
}
\details{
End users should just call \code{\link{umxLabel}}
}
\examples{
require(umx); data(demoOneFactor)
# raw but no means
m1 <- mxModel("One Factor", mxData(demoOneFactor, type = "raw"), type="RAM",
	manifestVars = "x1", latentVars= "G",
	umxPath("G", to = "x1"),
	umxPath(var = "x1"),
	umxPath(var = "G", fixedAt = 1)
)
xmuLabel_RAM_Model(m1)

}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_clean_label}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_dot_maker}},
  \code{\link{xmu_dot_move_ranks}},
  \code{\link{xmu_dot_rank_str}},
  \code{\link{xmu_lavaan_process_group}},
  \code{\link{xmu_make_mxData}},
  \code{\link{xmu_make_top_twin}},
  \code{\link{xmu_model_needs_means}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}},
  \code{\link{xmu_starts}}
}
\concept{xmu internal not for end user}
