% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxConfint}
\alias{umxConfint}
\title{Get confidence intervals from a umx model}
\usage{
umxConfint(
  object,
  parm = c("existing", "all", "or one or more labels", "smart"),
  wipeExistingRequests = TRUE,
  level = 0.95,
  run = FALSE,
  showErrorCodes = FALSE,
  optimizer = c("SLSQP", "NPSOL", "CSOLNP", "current")
)
}
\arguments{
\item{object}{An \code{\link[=mxModel]{mxModel()}}, possibly already containing \code{\link[=mxCI]{mxCI()}}s that have been \code{\link[=mxRun]{mxRun()}} with intervals = TRUE))}

\item{parm}{Which parameters to get confidence intervals for. Can be "existing", "all", or one or more parameter names.}

\item{wipeExistingRequests}{Whether to remove existing CIs when adding new ones (ignored if parm = 'existing').}

\item{level}{The confidence level required (default = .95)}

\item{run}{Whether to run the model (defaults to FALSE)}

\item{showErrorCodes}{(default = FALSE)}

\item{optimizer}{For difficult CIs, trying other optimizers can help!}

\item{...}{Additional argument(s) for umxConfint.}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Implements confidence interval function for umx models.
}
\details{
Note: By default, requesting new CIs wipes the existing ones.
To keep these, set wipeExistingRequests = FALSE.

\emph{Note}: \code{\link[=confint]{confint()}} is an OpenMx function which will return SE-based CIs.

Because these can take time to run, by default only CIs already computed will be reported. Set run = TRUE to run new CIs.
If \code{parm} is empty, and \code{run = FALSE}, a message will alert you to set \code{run = TRUE}.
}
\examples{
require(umx)
data(demoOneFactor)

manifests = names(demoOneFactor)
m1 = umxRAM("OneFactor", data = demoOneFactor, type = "cov",
	umxPath(from = "G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)

m1 = umxConfint(m1, run = TRUE) # There are no existing CI requests...

# Add a CI request for "G_to_x1", run, and report. Save with this CI computed
m2 = umxConfint(m1, parm = "G_to_x1", run = TRUE) 

# Just print out any existing CIs
umxConfint(m2) 

# CI requests added for free matrix parameters. User prompted to set run = TRUE
m3 = umxConfint(m1, "all")

# Run the requested CIs
m3 = umxConfint(m3, run = TRUE) 

# Run CIs for free one-headed (asymmetric) paths in RAM model. 
#   note: Deletes other existing requests,
tmp = umxConfint(m1, parm = "A", run = TRUE)

# Wipe existing CIs, add G_to_x1
tmp = umxConfint(m1, parm = "G_to_x1", run = TRUE, wipeExistingRequests = TRUE) 

\dontrun{
# For some twin models, "all" uses a "smart" mode
# note: only implemented for umxCP so far
m2 =  umxConfint(m1, "all")
}

}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[stats:confint]{stats::confint()}}, \code{\link[OpenMx:mxSE]{OpenMx::mxSE()}}, \code{\link[=umxCI]{umxCI()}}, \code{\link[OpenMx:mxCI]{OpenMx::mxCI()}}
}

Other Reporting functions: \code{\link{RMSEA.MxModel}()},
  \code{\link{RMSEA.summary.mxmodel}()},
  \code{\link{RMSEA}()},
  \code{\link{extractAIC.MxModel}()},
  \code{\link{loadings}()},
  \code{\link{residuals.MxModel}()},
  \code{\link{umxCI_boot}()}, \code{\link{umxCI}()},
  \code{\link{umxCompare}()}, \code{\link{umxExpCov}()},
  \code{\link{umxExpMeans}()},
  \code{\link{umxFitIndices}()},
  \code{\link{umxPlotACEv}()}, \code{\link{umxRotate}()},
  \code{\link{umxSummary.MxModel}()}
}
\concept{Reporting functions}
