% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_check_parallel}
\alias{umx_check_parallel}
\title{Check if OpenMx is using OpenMP, test cores, and get timings}
\usage{
umx_check_parallel(
  nCores = c(1, imxGetNumThreads()),
  testScript = NULL,
  rowwiseParallel = TRUE,
  nSubjects = 1000
)
}
\arguments{
\item{nCores}{How many cores to run (defaults to c(1, max). -1 = all available.}

\item{testScript}{A user-provided script to run (NULL)}

\item{rowwiseParallel}{Whether to parallel-ize rows (default) or gradient computation}

\item{nSubjects}{Number of rows to model (Default = 1000) Reduce for quicker runs.}
}
\value{
None
}
\description{
Shows how many cores you are using, and runs a test script so user can check CPU usage.
}
\details{
Some historical (starting 2017-09-06) speeds on my late 2015 iMac, 3.3 GHz Quad-core i7 desktop.

\tabular{rllll}{
date       \tab type            \tab Cores   \tab Time              \tab                                 \cr
2019-06-13 \tab v2.13.2 (OpenMP git)  \tab 1 core  \tab 01 min, 11 sec    \tab     (NPSOL)                   \cr
2019-06-13 \tab v2.13.2 (OpenMP git)  \tab 4 core  \tab 00 min, 22 sec    \tab     (NPSOL)                   \cr
2019-06-13 \tab v2.13.2 (OpenMP git)  \tab 6 core  \tab 00 min, 21 sec    \tab     (NPSOL)                   \cr
2018-10-14 \tab v2.11.5 (OpenMP on CRAN)  \tab 4 cores  \tab 00 min, 36 sec    \tab \eqn{\Delta}:-39.598) \cr
2018-09-17 \tab v2.11.3         \tab 1    \tab 01 min, 31 sec    \tab                                 \cr
2018-09-17 \tab v2.11.3         \tab 4    \tab 00 min, 30.6 sec  \tab \eqn{\Delta}: -61.49) \cr
2017-10-16 \tab v2.7.18-9       \tab 1    \tab 01 min, 07.30 sec \tab                                 \cr
2017-10-16 \tab v2.7.18-9       \tab 4    \tab 00 min, 22.63 sec \tab \eqn{\Delta}: -44.68) \cr
2017-10-16 \tab Clang OpenMP    \tab 1    \tab 01 min, 08.38 sec \tab                                 \cr
2017-10-16 \tab Clang OpenMP    \tab 4    \tab 00 min, 24.89 sec \tab \eqn{\Delta}: -43.49) \cr
2017-09-07 \tab Clang OpenMP    \tab 1    \tab 01 min, 12.90 sec \tab                                 \cr
2017-09-07 \tab Clang OpenMP    \tab 4    \tab 00 min, 32.20 sec \tab \eqn{\Delta}: -40.70   \cr
2017-09-07 \tab Clang notOpenMP \tab 1    \tab 01 min, 09.90 sec \tab                                 \cr
2017-09-07 \tab TRAVIS          \tab 1    \tab 01 min, 06.20 sec \tab                                 \cr
2017-09-07 \tab TRAVIS          \tab 4    \tab 00 min, 21.10 sec \tab \eqn{\Delta}: -45.00   \cr
}
}
\examples{
\dontrun{
# On a fast machine, takes a minute with 1 core
umx_check_parallel()
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Test: 
\code{\link{umx_check_OS}()},
\code{\link{umx_check_model}()},
\code{\link{umx_check_names}()},
\code{\link{umx_check}()},
\code{\link{umx_has_CIs}()},
\code{\link{umx_has_been_run}()},
\code{\link{umx_has_means}()},
\code{\link{umx_has_square_brackets}()},
\code{\link{umx_is_MxData}()},
\code{\link{umx_is_MxMatrix}()},
\code{\link{umx_is_MxModel}()},
\code{\link{umx_is_RAM}()},
\code{\link{umx_is_cov}()}
}
\concept{Test}
