% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{FishersMethod}
\alias{FishersMethod}
\title{Fishers Method of combining p-values.}
\usage{
FishersMethod(pvalues, ...)
}
\arguments{
\item{pvalues}{A vector of p-values, e.g. c(.041, .183)}

\item{...}{More p-values if you want to offer them up one by one instead of wrapping in a vector for \code{pvalues}}
}
\value{
\itemize{
\item A meta-analytic p-value
}
}
\description{
\code{FishersMethod} implements R.A. Fisher's (1925) method for creating a meta-analytic p-value by combining a
set of p-values from tests of the same hypothesis in independent samples. See also Stouffer's method
for combining Z scores, which allows weighting.
}
\examples{
FishersMethod(c(.041, .378))
}
\references{
\itemize{
\item Fisher, R.A. (1925). \emph{Statistical Methods for Research Workers}. Oliver and Boyd (Edinburgh). ISBN 0-05-002170-2.
}
\itemize{
\item Fisher, R. A (1948). "Questions and answers #14". \emph{The American Statistician}. \strong{2}: 30–31. doi: https://doi.org/10.2307/2681650.
\item Stouffer, S. A. and Suchman, E. A. and DeVinney, L. C. and Star, S. A. and Williams, R. M. Jr. (1949) The American Soldier,
Vol. 1 - Adjustment during Army Life. Princeton, Princeton University Press.
}
}
\seealso{
Other Miscellaneous Stats Functions: 
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Functions}
