% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_make_raw_from_cov}
\alias{umx_make_raw_from_cov}
\title{Turn a cov matrix into raw data}
\usage{
umx_make_raw_from_cov(covMat, n, means = 0, varNames = NULL, empirical = FALSE)
}
\arguments{
\item{covMat}{A covariance matrix}

\item{n}{How many rows of data to return}

\item{means}{the means of the raw data (default = 0)}

\item{varNames}{default uses "var1", "var2"}

\item{empirical}{(passed to mvrnorm) Default = FALSE}
}
\value{
\itemize{
\item data.frame
}
}
\description{
A wrapper for \code{\link[MASS:mvrnorm]{MASS::mvrnorm()}} to simplify turning a covariance matrix into matching raw data.
}
\examples{
covData <- matrix(nrow=6, ncol=6, byrow=TRUE, dimnames=list(paste0("v", 1:6), paste0("v", 1:6)),
  data = c(0.9223099, 0.1862938, 0.4374359, 0.8959973, 0.9928430, 0.5320662,
           0.1862938, 0.2889364, 0.3927790, 0.3321639, 0.3371594, 0.4476898,
           0.4374359, 0.3927790, 1.0069552, 0.6918755, 0.7482155, 0.9013952,
           0.8959973, 0.3321639, 0.6918755, 1.8059956, 1.6142005, 0.8040448,
           0.9928430, 0.3371594, 0.7482155, 1.6142005, 1.9223567, 0.8777786,
           0.5320662, 0.4476898, 0.9013952, 0.8040448, 0.8777786, 1.3997558)
)

myData = umx_make_raw_from_cov(covData, n = 100, means = 1:6)
umxAPA(myData)
covMat = matrix(c(1, .3, .3, 1), nrow=2)
tmp= umx_make_raw_from_cov(covMat, n=10, varNames= c("x", "y"))
cov(tmp)
tmp= umx_make_raw_from_cov(covMat, n=10, varNames= c("x", "y"), empirical= TRUE)
cov(tmp)
tmp= umx_make_raw_from_cov(qm(1, .3| .3, 1), n=10, varNames= c("x", "y"))
cov(tmp)
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=cov2cor]{cov2cor()}}, \code{\link[MASS:mvrnorm]{MASS::mvrnorm()}}
}

Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_anonymize}()},
\code{\link{prolific_check_ID}()},
\code{\link{prolific_read_demog}()},
\code{\link{umx}},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_merge_randomized_columns}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx_strings2numeric}()}
}
\concept{Data Functions}
