% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{xmuLabel}
\alias{xmuLabel}
\title{xmuLabel: Add labels to a RAM model, matrix, or path}
\usage{
xmuLabel(
  obj,
  suffix = "",
  baseName = NA,
  setfree = FALSE,
  drop = 0,
  labelFixedCells = TRUE,
  jiggle = NA,
  boundDiag = NA,
  verbose = FALSE,
  overRideExisting = FALSE,
  name = NULL
)
}
\arguments{
\item{obj}{An \code{\link[=mxModel]{mxModel()}} (RAM or matrix based), \code{\link[=mxPath]{mxPath()}}, or \code{\link[=mxMatrix]{mxMatrix()}}}

\item{suffix}{String to append to each label (might be used to distinguish, say male and female submodels in a model)}

\item{baseName}{String to prepend to labels. Defaults to NA ("")}

\item{setfree}{Whether to label only the free paths (defaults to FALSE)}

\item{drop}{The value to fix "drop" paths to (defaults to 0)}

\item{labelFixedCells}{= TRUE}

\item{jiggle}{How much to jiggle values in a matrix or list of path values}

\item{boundDiag}{Whether to bound the diagonal of a matrix}

\item{verbose}{How much feedback to give the user (default = FALSE)}

\item{overRideExisting}{= FALSE}

\item{name}{Optional new name if given a model. Default (NULL) does not rename model.}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
xmuLabel adds labels to things, be it an: \code{\link[=mxModel]{mxModel()}} (RAM or matrix based), an \code{\link[=mxPath]{mxPath()}}, or an \code{\link[=mxMatrix]{mxMatrix()}}
This is a core function in umx: Adding labels to paths opens the door to \code{\link[=umxEquate]{umxEquate()}}, as well as \code{\link[=omxSetParameters]{omxSetParameters()}}
}
\examples{
# ==============================================================
# = Show how OpenMx models are not labeled, and then add labels =
# ==============================================================
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 = mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents  , to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents  , arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs=500)
)

umxGetParameters(m1) # Default "matrix address" labels, i.e "One Factor.S[2,2]"
m1 = xmuLabel(m1)
umxGetParameters(m1, free = TRUE) # Informative labels: "G_to_x1", "x4_with_x4", etc.

# =======================================================================
# = Create a new model, with suffixes added to paths, and model renamed =
# =======================================================================
m2 = xmuLabel(m1, suffix= "_male", overRideExisting= TRUE, name = "male")
umxGetParameters(m2, free = TRUE) # suffixes added

# =============================
# = Example Labeling a matrix =
# =============================
a = xmuLabel(mxMatrix(name = "a", "Full", 3, 3, values = 1:9))
a$labels
a = xmuLabel(mxMatrix(name = "a", "Full", 3, 3, values = 1:9), baseName="bob")
a$labels
# note: labels with "data." in the name are left untouched!
a = mxMatrix(name = "a", "Full", 1,3, labels = c("data.a", "test", NA))
a$labels
xmuLabel(a, verbose = TRUE)
xmuLabel(a, verbose = TRUE, overRideExisting = FALSE)
xmuLabel(a, verbose = TRUE, overRideExisting = TRUE)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Advanced Model Building Functions: 
\code{\link{umxJiggle}()},
\code{\link{umxThresholdMatrix}()},
\code{\link{umx}},
\code{\link{xmuValues}()}
}
\concept{Advanced Model Building Functions}
