% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_rename}
\alias{umx_rename}
\title{umx_rename}
\usage{
umx_rename(
  data,
  from = NULL,
  to = NULL,
  regex = NULL,
  test = FALSE,
  old = "deprecated_from",
  replace = "deprecated_to"
)
}
\arguments{
\item{data}{The dataframe in which to rename variables}

\item{from}{List of existing names that will be found and replaced by the contents of replace. (optional: Defaults to NULL).}

\item{to}{If used alone, a named collection of c(oldName = "newName") pairs.
OR, if "from" is a list of existing names, the list of new names)
OR, if "regex" is a regular expression, the replace string)}

\item{regex}{Regular expression with matches will be replaced using replace as the replace string. (Optional: Defaults to NULL).}

\item{test}{Whether to report a "dry run", not changing anything. (Default = FALSE).}

\item{old}{deprecated: use from}

\item{replace}{deprecated: use to}
}
\value{
\itemize{
\item dataframe with columns renamed.
}
}
\description{
Returns a dataframe with variables renamed as desired.
}
\details{
Unlike similar functions in other packages, it checks that the variables exist, and that the new names do not.

Importantly, it also supports \link[=regex]{regular expressions}. This allows you to find and replace
text based on patterns and replacements. so to change "replacement" to "in place",
\verb{grep=re(place)ment}, \verb{replace= in \\\\1}.

\emph{note}:To use replace list, you must say c(old = "new"), not c(old -> "new")
}
\examples{
tmp = mtcars

tmp = umx_rename(tmp, to = c(cyl = "cylinder"))
# let's check cyl has been changed to cylinder...
namez(tmp, "c")

# Alternate style: from->to, first with a test-run
# Dry run
tmp = umx_rename(tmp, from = "disp", to = "displacement", test= TRUE)
# Actually do it
tmp = umx_rename(tmp, from = c("disp"), to = c("displacement"))
umx_check_names("displacement", data = tmp, die = TRUE)
namez(tmp, "disp")

# This will warn that "disp" does not exist (anymore)
new = c("auto", "displacement", "rear_axle_ratio")
tmp = umx_rename(tmp, from = c("am", "disp", "drat"), to = new)
namez(tmp, "a") # still updated am to auto (and rear_axle_ratio)

# Test using regex (in this case to revert "displacement" to "disp")
tmp = umx_rename(tmp, regex = "lacement", to = "", test= TRUE) 
tmp = umx_rename(tmp, regex = "lacement", to = "") # revert to disp
umx_names(tmp, "^d") # all names beginning with a d

# dev: check deprecated format handled...
tmp = umx_rename(tmp, old = c("am", "disp", "drat"), replace = new)
}
\seealso{
\link{namez} to filter (and replace) names, Also \link{umx_check_names} to check for existence of names in a dataframe.

Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_anonymize}()},
\code{\link{prolific_check_ID}()},
\code{\link{prolific_read_demog}()},
\code{\link{umx}},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_merge_randomized_columns}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx_strings2numeric}()}
}
\concept{Data Functions}
