% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_percent}
\alias{fin_percent}
\title{Compute the percent change needed to return to the original value after percent off (or on).}
\usage{
fin_percent(percent, value = 100, symbol = "$", digits = 2, plot = TRUE)
}
\arguments{
\item{percent}{Change in percent (enter 10 for 10\%, not 0.1)}

\item{value}{Principal}

\item{symbol}{value units (default = "$")}

\item{digits}{Rounding of results (default 2 places)}

\item{plot}{Whether to plot the result (default TRUE)}
}
\value{
\itemize{
\item new value and change required to return to baseline.
}
}
\description{
Determine the percent change needed to "undo" an initial percent change. Has a plot function as well.
If an amount of \$100 has 20\\% added, what percent do we need to drop it by to return to the original value?
\code{fin_percent(20)} yields \$100 increased by 20\\% = \$120 (Percent to reverse = -17\\%)
}
\examples{
# Percent needed to return to original value after 10\% taken off
fin_percent(-10)

# Percent needed to return to original value after 10\% added on
fin_percent(10)

# Percent needed to return to original value after 50\% off 34.50
fin_percent(-50, value = 34.5)
}
\seealso{
\itemize{
\item \code{\link[=fin_interest]{fin_interest()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_interest}()},
\code{\link{fin_valuation}()},
\code{\link{rad2deg}()}
}
\concept{Miscellaneous Functions}
