% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnno.R
\docType{methods}
\name{parseInputFile}
\alias{parseInputFile}
\alias{parseInputFile,geneanno-method}
\title{Parse files of gene names and group identifiers to create unique lists of each}
\usage{
parseInputFile(x, file)

\S4method{parseInputFile}{geneanno}(x, file)
}
\arguments{
\item{x}{object of class geneanno.}

\item{file}{character string providing the name of the input file}
}
\value{
vector of character strings, as exemplified by the inputlist data object.
}
\description{
\code{parseInputFile} takes a mixed file containing group identifiers (numeric) and gene names, returning the list of group identifiers and genes with the remaining columns removed.
The package was originally written to work from a file laid out thus:
group_id1
gene_name1
gene_name2
group_id2
gene_name1
gene_name3
The methods assume that both group identifiers and gene names are alphanumeric; the group identifiers, where present, begining with a number and gene names starting with a character.
please note, this populates the vector with only the alphanumric strings begining each line of the input file. Also, RNA genes (begining ENSG000) are excluded.
}
\section{Methods (by class)}{
\itemize{
\item \code{geneanno}: vector of character strings
}}

