% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_2_accent}
\alias{stanford_2_accent}
\title{Accent colors of Stanford University, USA}
\format{
An object of class \code{character} of length 42.
}
\source{
Color definitions are based on the
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_2_accent
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_2_accent} provides the 42 accent colors
of the \href{https://www.stanford.edu/}{Stanford University}, USA.
}
\details{
Although our primary palette should drive most Stanford communications materials, other colors can be added as appropriate.
For those circumstances, we have developed this accent palette.

These colors are intended to compliment our Stanford primary colors: 
\code{"palo_alto"} (defined as HEX #175E54),
\code{"palo_alto_light"} (defined as HEX #2D716F),
\code{"palo_alto_dark"} (defined as HEX #014240),
\code{"palo_verde"} (defined as HEX #279989),
\code{"palo_verde_light"} (defined as HEX #59B3A9),
\code{"palo_verde_dark"} (defined as HEX #017E7C),
\code{"olive"} (defined as HEX #8F993E),
\code{"olive_light"} (defined as HEX #A6B168),
\code{"olive_dark"} (defined as HEX #7A863B),
\code{"bay"} (defined as HEX #6FA287),
\code{"bay_light"} (defined as HEX #8AB8A7),
\code{"bay_dark"} (defined as HEX #417865),
\code{"sky"} (defined as HEX #4298B5),
\code{"sky_light"} (defined as HEX #67AFD2),
\code{"sky_dark"} (defined as HEX #016895),
\code{"lagunita"} (defined as HEX #007C92),
\code{"lagunita_light"} (defined as HEX #009AB4),
\code{"lagunita_dark"} (defined as HEX #006B81),
\code{"poppy"} (defined as HEX #E98300),
\code{"poppy_light"} (defined as HEX #F9A44A),
\code{"poppy_dark"} (defined as HEX #D1660F),
\code{"spirited"} (defined as HEX #E04F39),
\code{"spirited_light"} (defined as HEX #F4795B),
\code{"spirited_dark"} (defined as HEX #C74632),
\code{"illuminating"} (defined as HEX #FEDD5C),
\code{"illuminating_light"} (defined as HEX #FFE781),
\code{"illuminating_dark"} (defined as HEX #FEC51D),
\code{"plum"} (defined as HEX #620059),
\code{"plum_light"} (defined as HEX #734675),
\code{"plum_dark"} (defined as HEX #350D36),
\code{"brick"} (defined as HEX #651C32),
\code{"brick_light"} (defined as HEX #7F2D48),
\code{"brick_dark"} (defined as HEX #42081B),
\code{"archway"} (defined as HEX #5D4B3C),
\code{"archway_light"} (defined as HEX #766253),
\code{"archway_dark"} (defined as HEX #2F2424),
\code{"stone"} (defined as HEX #7F7776),
\code{"stone_light"} (defined as HEX #D4D1D1),
\code{"stone_dark"} (defined as HEX #544948),
\code{"fog"} (defined as HEX #DAD7CB),
\code{"fog_light"} (defined as HEX #F4F4F4) and
\code{"fog_dark"} (defined as HEX #B6B1A9)
}
\examples{
stanford_2_accent
unikn::seecol(stanford_2_accent, main = "Accent colors Stanford Uni") # view color palette

}
\seealso{
\code{\link{stanford_1}} for primary colors of Stanford University;
\code{\link{stanford_3_web}} for web colors of Stanford University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
