% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_text_calls.R
\name{heading}
\alias{heading}
\title{Plot a heading (as marked text elements).}
\usage{
heading(labels, x = 0, y = 0.8, y_layout = "flush", col = "black",
  col_bg = "default", cex = 2, font = 2, new_plot = "slide")
}
\arguments{
\item{labels}{A character vector specifying the text labels 
to be plotted.}

\item{x}{A numeric vector of x-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{x = 0}.}

\item{y}{A numeric vector of y-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{y = .8}.}

\item{y_layout}{A numeric value or vector for the vertical 
spacing of labels in \code{labels}. 
2 special values are 
\code{"even"} (i.e., even distribution of labels across available y-space) and 
\code{"flush"} (i.e., no space between adjacent labels, or \code{y_layout = 0}). 
Default: \code{y_layout = "flush"}.}

\item{col}{The color(s) of the text label(s). 
Default: \code{col_lbl = "black"}.}

\item{col_bg}{The color(s) to highlight or fill the rectangle(s) with. 
Default: \code{col_bg = "default"} (to automatically select different 
shades of \code{\link{pal_seeblau}}).}

\item{cex}{Numeric character expansion factor(s), 
multiplied by \code{par("cex")} to yield the character size(s). 
Default: \code{cex = 2}.}

\item{font}{The font type(s) to be used. 
Default: \code{font = 2} (i.e., bold).}

\item{new_plot}{Boolean: Should a new plot be generated?
Set to \code{"blank"} or \code{"slide"} to create a new plot, 
and to \code{"none"} to add to an existing plot. 
Default: \code{new_plot = "slide"} (i.e., create a new \code{\link{slide}}).}
}
\description{
\code{heading} plots 1 or more text strings (provided as a character vector \code{labels}) 
as a heading to an (existing or new) plot and places a colored box behind
each label to mark it (i.e., highlighting the heading).
}
\details{
Text formatting parameters (like \code{col}, \code{col_bg}, \code{cex}, \code{font})         
are recycled to match \code{length(labels)}.

\code{heading} uses the base graphics system \code{graphics::}.
}
\examples{
heading(labels = c("This is a headline", "containing two lines."))

# Note the warning:
heading(labels = c("Headlines", "with 3 or more lines", 
                 "should not be arranged", "in such a step-wise fashion.")) 

# Avoiding the warning:
heading(labels = c("Headlines with", "3 or more lines should", 
                   "not be arranged", "in a step-wise fashion."))

# Using non-default colors:
heading(labels = c("Ene,", "mene, miste,", "es rappelt", "in der Kiste."), 
        cex = 1.6, col = "white", col_bg = usecol(c(Pinky, Seegruen, Bordeaux, Karpfenblau)))

#' @family text functions

}
\seealso{
\code{\link{slide}} and \code{\link{xbox}} to create simple plots (without text).
}
