% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_text_calls.R
\name{post}
\alias{post}
\title{Post text (in an xbox).}
\usage{
post(labels, x = 0.03, y = 0.55, y_layout = "even", col = "white",
  col_bg = Seeblau, cex = 1, font = 1, new_plot = "none")
}
\arguments{
\item{labels}{A character vector specifying the text labels 
to be plotted.}

\item{x}{A numeric vector of x-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{x = .03}.}

\item{y}{A numeric vector of y-coordinates at which the 
text labels in \code{labels} should be written. 
If the lengths of \code{x} and \code{y} differ, 
the shorter one is recycled. 
Default: \code{y = .55}.}

\item{y_layout}{A numeric value or vector for the vertical 
spacing of labels in \code{labels}. 
2 special values are 
\code{"even"} (i.e., even distribution of labels across available y-space) and 
\code{"flush"} (i.e., no space between adjacent labels, or \code{y_layout = 0}). 
Default: \code{y_layout = "even"}.}

\item{col}{The color(s) of the text label(s). 
Default: \code{col_lbl = "white"}.}

\item{col_bg}{The background color(s) of the \code{\link{xbox}}. 
Default: \code{col_bg = Seeblau}.}

\item{cex}{Numeric character expansion factor(s), 
multiplied by \code{par("cex")} to yield the character size(s). 
Default: \code{cex = 1.0}.}

\item{font}{The font type(s) to be used. 
Default: \code{font = 1} (i.e., plain text).}

\item{new_plot}{Should a new plot be generated?
Set to \code{"xbox"} to plot to a basic \code{\link{xbox}} 
(with square dimensions, i.e., \code{dim = c(1, 1)}).  
Default: \code{new_plot = "none"} (i.e., assumes a pre-existing \code{\link{xbox}}).}
}
\description{
\code{post} plots 1 or more text strings (provided as a character vector \code{labels}) 
to an (existing or new) \code{\link{xbox}}.
}
\details{
The positions of the text elements in \code{labels} can be specified by 
providing their coordinates (as \code{x} and \code{y} arguments) or 
by providing an initial position and an \code{y_layout} (see below).

Text formatting parameters (like \code{col}, \code{col_bg}, \code{cex}, \code{font})         
are recycled to match \code{length(labels)}.

\code{post} uses the base graphics system \code{graphics::}.
}
\examples{
post(labels = "Post this line with default settings.", new_plot = "xbox")

# Create a new xbox: 
post(labels = "This is a test.", new_plot = "xbox", 
     cex = 1.2, font = 2, col_bg = pal_seeblau[[5]])

# Add text to an existing xbox: 
post(labels = c("More text follows here,",
              "yet another line here,",
              "and even more here."), 
              y = .4, y_layout = .04, 
              new_plot = "none")
                        
}
\seealso{
\code{\link{xbox}} to create a new xbox (without text).

Other text functions: \code{\link{mark}},
  \code{\link{uline}}, \code{\link{url_unikn}}
}
\concept{text functions}
