% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oracle.R
\name{oracle_cor_from_joint}
\alias{oracle_cor_from_joint}
\title{Calculate the correlation of the oracle estimator with the true
genotype from the joint distribution matrix.}
\usage{
oracle_cor_from_joint(jd)
}
\arguments{
\item{jd}{A matrix of numerics. Element (i, j) is the probability
of genotype i - 1 and estimated genotype j - 1. This is usually
obtained from \code{\link{oracle_joint}}.}
}
\value{
The Pearson correlation between the true genotype and the oracle estimator.
}
\description{
Calculates the correlation between the oracle MAP estimator (where we have perfect
knowledge about the data generation process) and the true genotype. This is a useful
approximation when you have a lot of individuals.
}
\examples{
## Hardy-Weinberg population with allele-frequency of 0.75.
## Moderate bias and moderate overdispersion.
ploidy <- 6
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
jd <- oracle_joint(n = 100, ploidy = ploidy, seq = 0.001,
                   bias = 0.7, od = 0.01, dist = dist)
oracle_cor_from_joint(jd = jd)

## Compare to oracle_cor
oracle_cor(n = 100, ploidy = ploidy, seq = 0.001,
           bias = 0.7, od = 0.01, dist = dist)


}
\seealso{
\code{\link{oracle_joint}} for getting \code{jd}.
    \code{\link{oracle_cor}} for not having to first calculate
    \code{jd}.
}
\author{
David Gerard
}
