% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{obj_for_mu_sigma2_wrapper}
\alias{obj_for_mu_sigma2_wrapper}
\title{Wrapper for \code{\link{obj_for_mu_sigma2}} so that I can use it in \code{optim}.}
\usage{
obj_for_mu_sigma2_wrapper(muSigma2, phifk_mat, cor_inv, log_bb_dense)
}
\arguments{
\item{muSigma2}{A vector. The first half are mu and the second half are sigma2.}

\item{phifk_mat}{A matrix that contains the standard normal quantile of the beta-binomial cdf at dosage k for individual i.
The rows index the individuals and the columns index the dosages.}

\item{cor_inv}{The inverse of the underlying correlation matrix.}

\item{log_bb_dense}{A matrix of log-densities of the beta binomial. The rows index the individuals and the columns index the allele dosage.
Allele dosage goes from -1 to ploidy, so there are ploidy + 2 elements.}
}
\value{
A double. The objective when updating \code{mu} and \code{sigma2}
    in \code{\link{mupdog}}.
}
\description{
Wrapper for \code{\link{obj_for_mu_sigma2}} so that I can use it in \code{optim}.
}
\author{
David Gerard
}
\keyword{internal}
