% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_shorten_link}
\alias{bitly_shorten_link}
\title{Shorten a Link}
\usage{
bitly_shorten_link(domain = "bit.ly", group_guid = NULL,
  long_url = NULL, showRequestURL = FALSE)
}
\arguments{
\item{domain}{- (optional) the short domain to use; either bit.ly, j.mp, or bitly.com or
a custom short domain. The default for this parameter is the short domain selected by each
user in their bitly account settings. Passing a specific domain via this parameter will override
the default settings.}

\item{group_guid}{- a GUID for a Bitly group}

\item{long_url}{- required, a long URL to be shortened (example: http://betaworks.com/). 
Must contain http/https}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}
}
\description{
See \url{https://dev.bitly.com/v4/#operation/createBitlink}
Convert a long url to a Bitlink
}
\examples{
\dontrun{
bitly_shorten_link(url = "http://www.seznam.cz/")
bitly_shorten_link(url = "http://www.seznam.cz/", showRequestURL = TRUE)

manyUrls <- list(
  "http://www.seznam.cz/", "http://www.seznamasdas.cz/",
  "http://www.seznam.cz/asadasd", "http://www.seznam.cz/adqwrewtregt"
)
for (u in 1:length(manyUrls)) {
  print(bitly_shorten_link(long_url = manyUrls[[u]], showRequestURL = TRUE))
}
}
}
